/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.resp;

import cn.kinyun.scrm.weixin.sdk.entity.message.resp.Article;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import cn.kinyun.scrm.weixin.sdk.utils.MsgXmlBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.List;

public class NewsMsg
extends BaseRespMsg {
    private static final long serialVersionUID = -8211099268651467294L;
    private static final int MAX_ARTICLE_COUNT = 8;
    @JsonIgnore
    private int maxSize = 8;
    private List<Article> articles;

    public NewsMsg() {
        this.msgType = WxMsgType.News.getValue();
        this.maxSize = 8;
        this.articles = Lists.newArrayListWithCapacity((int)8);
    }

    public NewsMsg(int maxSize) {
        this.msgType = WxMsgType.News.getValue();
        this.setMaxSize(maxSize);
        this.articles = Lists.newArrayListWithCapacity((int)this.maxSize);
    }

    public NewsMsg(List<Article> articles) {
        this.msgType = WxMsgType.News.getValue();
        this.maxSize = 8;
        this.articles = Lists.newArrayListWithCapacity((int)8);
        this.setArticles(articles);
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 8 && maxSize >= 1) {
            this.maxSize = maxSize;
        }
    }

    public void setArticles(List<Article> articles) {
        if (this.articles.size() > 0) {
            this.articles.clear();
        }
        this.articles.addAll(articles);
    }

    public void add(String title) {
        this.add(title, null, null, null);
    }

    public void add(String title, String url) {
        this.add(title, null, null, url);
    }

    public void add(String title, String picUrl, String url) {
        this.add(new Article(title, null, picUrl, url));
    }

    public void add(String title, String description, String picUrl, String url) {
        this.add(new Article(title, description, picUrl, url));
    }

    public void add(Article article) {
        if (article != null && this.articles.size() < this.maxSize) {
            this.articles.add(article);
        }
    }

    @Override
    public String toXml() {
        MsgXmlBuilder builder = new MsgXmlBuilder(super.toXml());
        builder.addTag("ArticleCount", String.valueOf(this.articles.size()));
        builder.append("<Articles>");
        for (int i = 0; i < this.maxSize && i < this.articles.size(); ++i) {
            Article article = this.articles.get(i);
            MsgXmlBuilder subBuilder = new MsgXmlBuilder();
            subBuilder.addCData("Title", article.getTitle());
            subBuilder.addCData("Description", article.getDescription());
            subBuilder.addCData("PicUrl", article.getPicUrl());
            subBuilder.addCData("Url", article.getUrl());
            subBuilder.surroundWith("item");
            builder.append(subBuilder.toString());
        }
        builder.append("</Articles>");
        return builder.toString();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public List<Article> getArticles() {
        return this.articles;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewsMsg)) {
            return false;
        }
        NewsMsg other = (NewsMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        List<Article> this$articles = this.getArticles();
        List<Article> other$articles = other.getArticles();
        return !(this$articles == null ? other$articles != null : !((Object)this$articles).equals(other$articles));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NewsMsg;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMaxSize();
        List<Article> $articles = this.getArticles();
        result = result * 59 + ($articles == null ? 43 : ((Object)$articles).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "NewsMsg(super=" + super.toString() + ", maxSize=" + this.getMaxSize() + ", articles=" + this.getArticles() + ")";
    }
}

