/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.emoji;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WxEmojiUtils {
    public static final String DECODE_REGEX = "[\\uE001-\\uE5FF]";
    public static Map<String, String> DECODE_MAP = new HashMap<String, String>();
    public static final String ENCODE_REGEX = "[\\uD83C\\uDDE0-\\uD83C\\uDDFF][\\uD83C\\uDDE0-\\uD83C\\uDDFF]|[\\uD83C\\uDC00-\\uD83C\\uDFFF]|[\\uD83D\\uDC00-\\uD83D\\uDFFF]";
    public static Map<String, String> ENCODE_MAP = new HashMap<String, String>();

    public static String replace(String source, String regex, Map<String, String> map) {
        if (source == null || source.trim().length() == 0) {
            return source;
        }
        if (source != null && source.length() > 0) {
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            Pattern emoji = Pattern.compile(regex, 2);
            Matcher m = emoji.matcher(source);
            while (m.find()) {
                String key = m.group();
                String value = map.get(key);
                if (value == null) continue;
                tmpMap.put(key, value);
            }
            if (!tmpMap.isEmpty()) {
                for (Map.Entry entry : tmpMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    source = source.replace(key, value);
                }
            }
        }
        return source;
    }

    public static boolean contains(String source, String regex) {
        Pattern p;
        Matcher m;
        boolean result = false;
        if (source != null && source.length() > 0 && (m = (p = Pattern.compile(regex, 2)).matcher(source)).find()) {
            result = true;
        }
        return result;
    }

    public static String decode(String source) {
        return WxEmojiUtils.replace(source, DECODE_REGEX, DECODE_MAP);
    }

    public static String encode(String source) {
        return WxEmojiUtils.replace(source, ENCODE_REGEX, ENCODE_MAP);
    }

    public static boolean containsSoftbankEmoji(String source) {
        return WxEmojiUtils.contains(source, DECODE_REGEX);
    }

    public static boolean containsUnicodeEmoji(String source) {
        return WxEmojiUtils.contains(source, ENCODE_REGEX);
    }

    static {
        Properties prop = new Properties();
        try {
            InputStream in = WxEmojiUtils.class.getResourceAsStream("/emoji.properties");
            prop.load(in);
            prop.entrySet().forEach(it -> {
                String key = (String)it.getKey();
                String value = (String)it.getValue();
                DECODE_MAP.put(key, value);
                ENCODE_MAP.put(value, key);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

