/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.applet;

import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.GetUserPhoneReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.JsCode2SessionReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.AppletSessionResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.GetUserPhoneResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AppletAPI {
    private static final Logger log = LoggerFactory.getLogger(AppletAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.applet.sns.jscode2session.url}")
    private String snsJsCode2Session;
    @Value(value="${wx.applet.getPhoneNumber.url}")
    private String getPhoneNumberUrl;

    public AppletSessionResp code2Session(JsCode2SessionReq req) {
        log.info("code2Session with req={}", (Object)req);
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        String url = MessageFormat.format(this.snsJsCode2Session, req.getAppId(), req.getJsCode(), req.getComponentAppId(), req.getComponentAccessToken());
        ResponseEntity resp = this.restTemplate.getForEntity(url, AppletSessionResp.class, new Object[0]);
        AppletSessionResp result = (AppletSessionResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public GetUserPhoneResp getUserPhoneNumber(String accessToken, String code) {
        log.info("getUserPhoneNumber with code={}", (Object)code);
        Preconditions.checkArgument((boolean)Objects.nonNull(code), (Object)"code\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(accessToken), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        GetUserPhoneReq req = new GetUserPhoneReq();
        req.setCode(code);
        String url = MessageFormat.format(this.getPhoneNumberUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, GetUserPhoneResp.class, new Object[0]);
        GetUserPhoneResp result = (GetUserPhoneResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

