/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.user.req.BatchTaggingReq;
import cn.kinyun.scrm.weixin.sdk.entity.user.req.BatchUserInfoReq;
import cn.kinyun.scrm.weixin.sdk.entity.user.resp.UserInfo;
import cn.kinyun.scrm.weixin.sdk.entity.user.resp.UserInfoListResp;
import cn.kinyun.scrm.weixin.sdk.entity.user.resp.UserListResp;
import cn.kinyun.scrm.weixin.sdk.entity.user.resp.UserTagListResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxUserAPI {
    private static final Logger log = LoggerFactory.getLogger(WxUserAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.user.getList}")
    private String wxUserGetList;
    @Value(value="${wx.user.getInfo}")
    private String wxUserGetInfo;
    @Value(value="${wx.user.batchGetInfo}")
    private String wxUserBatchGetInfo;
    @Value(value="${wx.user.tag.get}")
    private String wxUserTagGet;
    @Value(value="${wx.user.tag.batchtagging}")
    private String wxUserTagBatchtagging;
    @Value(value="${wx.user.tag.batchuntagging}")
    private String wxUserTagBatchuntagging;
    @Value(value="${wx.user.tag.getIdList}")
    private String wxUserTagGetIdList;
    @Value(value="${wx.tag.member.getblacklist}")
    private String wxTagMemberGetblacklist;
    @Value(value="${wx.tag.member.batchblacklist")
    private String wxTagMemberBatchblacklist;
    @Value(value="${wx.tag.member.batchunblacklist}")
    private String wxTagMemberBatchunblacklist;

    public UserListResp getList(@NonNull String accessToken, String nextOpenId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get user list with next_openid={}", (Object)nextOpenId);
        String url = MessageFormat.format(this.wxUserGetList, accessToken);
        if (nextOpenId != null) {
            url = url + "&next_openid=" + nextOpenId;
        }
        ResponseEntity response = this.restTemplate.postForEntity(url, null, UserListResp.class, new Object[0]);
        UserListResp result = (UserListResp)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UserInfo getUserInfo(@NonNull String accessToken, @NonNull String openId, @NonNull String lang) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        if (lang == null) {
            throw new NullPointerException("lang is marked non-null but is null");
        }
        log.info("get user info with openid={}, lang={}", (Object)openId, (Object)lang);
        String url = MessageFormat.format(this.wxUserGetInfo, accessToken, openId, lang);
        ResponseEntity response = this.restTemplate.postForEntity(url, null, UserInfo.class, new Object[0]);
        UserInfo result = (UserInfo)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UserInfoListResp batchGetUserInfo(@NonNull String accessToken, @NonNull BatchUserInfoReq batchUserInfoReq) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (batchUserInfoReq == null) {
            throw new NullPointerException("batchUserInfoReq is marked non-null but is null");
        }
        log.info("batch get user info with userList.size={}", (Object)(CollectionUtils.isNotEmpty(batchUserInfoReq.getUserList()) ? batchUserInfoReq.getUserList().size() : 0));
        String url = MessageFormat.format(this.wxUserBatchGetInfo, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)batchUserInfoReq, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserInfoListResp.class, new Object[0]);
        UserInfoListResp result = (UserInfoListResp)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UserListResp tagGet(@NonNull String accessToken, @NonNull Long tagId, String nextOpenId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (tagId == null) {
            throw new NullPointerException("tagId is marked non-null but is null");
        }
        log.info("get user list with tag_id={}, next_openid={}", (Object)tagId, (Object)nextOpenId);
        String url = MessageFormat.format(this.wxUserTagGet, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("tagid", tagId);
        params.put("next_openid", nextOpenId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserListResp.class, new Object[0]);
        UserListResp result = (UserListResp)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public void batchTagging(@NonNull String accessToken, @NonNull BatchTaggingReq batchTaggingReq) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (batchTaggingReq == null) {
            throw new NullPointerException("batchTaggingReq is marked non-null but is null");
        }
        log.info("batch tagging with params={}", (Object)batchTaggingReq);
        String url = MessageFormat.format(this.wxUserTagBatchtagging, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)batchTaggingReq, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)response.getBody();
        WeixinException.isSuccess(result);
    }

    public void batchUnTagging(@NonNull String accessToken, @NonNull BatchTaggingReq batchTaggingReq) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (batchTaggingReq == null) {
            throw new NullPointerException("batchTaggingReq is marked non-null but is null");
        }
        log.info("batch untagging with params={}", (Object)batchTaggingReq);
        String url = MessageFormat.format(this.wxUserTagBatchuntagging, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)batchTaggingReq, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)response.getBody();
        WeixinException.isSuccess(result);
    }

    public UserTagListResp userTagGetIdList(@NonNull String accessToken, @NonNull String openId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        log.info("get user tag list with openid={}", (Object)openId);
        String url = MessageFormat.format(this.wxUserTagGetIdList, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("openid", openId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserTagListResp.class, new Object[0]);
        UserTagListResp result = (UserTagListResp)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public void userTagGetIdList(@NonNull String accessToken, @NonNull String openId, @NonNull String remark) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        if (remark == null) {
            throw new NullPointerException("remark is marked non-null but is null");
        }
        log.info("set user remark with openid={}, remark={}", (Object)openId, (Object)remark);
        String url = MessageFormat.format(this.wxUserTagGetIdList, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("openid", openId);
        params.put("remark", remark);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)response.getBody();
        WeixinException.isSuccess(result);
    }

    public UserListResp getBlackList(@NonNull String accessToken, String beginOpenId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get black list with begin_openid={}", (Object)beginOpenId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        String url = MessageFormat.format(this.wxTagMemberGetblacklist, accessToken);
        HashMap params = Maps.newHashMap();
        params.put("begin_openid", beginOpenId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserListResp.class, new Object[0]);
        UserListResp result = (UserListResp)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public void batchBlackList(@NonNull String accessToken, List<String> openIdList) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("batch black list with openid_list={}", openIdList);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        String url = MessageFormat.format(this.wxTagMemberBatchblacklist, accessToken);
        HashMap params = Maps.newHashMap();
        params.put("openid_list", openIdList);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)response.getBody();
        WeixinException.isSuccess(result);
    }

    public void batchUnBlackList(@NonNull String accessToken, List<String> openIdList) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("batch unblack list with openid_list={}", openIdList);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        String url = MessageFormat.format(this.wxTagMemberBatchunblacklist, accessToken);
        HashMap params = Maps.newHashMap();
        params.put("openid_list", openIdList);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)response.getBody();
        WeixinException.isSuccess(result);
    }
}

