/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api;

import cn.kinyun.scrm.weixin.sdk.api.WxBasicAPI;
import cn.kinyun.scrm.weixin.sdk.entity.basic.Ticket;
import cn.kinyun.scrm.weixin.sdk.entity.jssdk.UrlSignature;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.sdk.utils.aes.AesException;
import cn.kinyun.scrm.weixin.sdk.utils.aes.SHA1;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxJsSdkAPI {
    private static final Logger log = LoggerFactory.getLogger(WxJsSdkAPI.class);
    @Autowired
    private WxBasicAPI wxBasicApi;

    public Ticket getJsApiTicket(@NonNull String accessToken) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        return this.wxBasicApi.getTicket(accessToken, "jsapi");
    }

    public UrlSignature signature(@NonNull String url, @NonNull String jsApiTicket, @NonNull String appId) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (jsApiTicket == null) {
            throw new NullPointerException("jsApiTicket is marked non-null but is null");
        }
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        log.info("signature for url={}", (Object)url);
        String nonceStr = UUID.randomUUID().toString();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("jsapi_ticket", jsApiTicket);
        paramMap.put("noncestr", nonceStr);
        paramMap.put("timestamp", timestamp);
        paramMap.put("url", url);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : paramMap.entrySet()) {
            sb.append("&").append(entry.toString());
        }
        String signature = null;
        try {
            signature = SHA1.sha1(sb.toString());
        }
        catch (AesException e) {
            e.printStackTrace();
        }
        UrlSignature sign = new UrlSignature();
        sign.setAppId(appId);
        sign.setNonceStr(nonceStr);
        sign.setTimestamp(timestamp);
        sign.setSignature(signature);
        sign.setUrl(url);
        return sign;
    }
}

