/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import com.kuaike.scrm.common.enums.NetSchoolShopTypeEnum;
import java.util.HashMap;
import java.util.Map;

public enum NetSchoolGoodsTypeEnum {
    SCRM(0, "scrm\u5546\u54c1"),
    COURSE(1, "\u8bfe\u7a0b"),
    CLASS(2, "\u73ed\u7ea7"),
    CLASS_PACK(3, "\u8bfe\u65f6\u5305");

    private final int value;
    private final String desc;
    private static final Map<Integer, NetSchoolGoodsTypeEnum> CACHE;

    private NetSchoolGoodsTypeEnum(int id, String name) {
        this.value = id;
        this.desc = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static NetSchoolGoodsTypeEnum get(Integer status) {
        return CACHE.get(status);
    }

    public static String getDesc(Integer status) {
        NetSchoolGoodsTypeEnum netSchoolGoodsTypeEnum = CACHE.get(status);
        return netSchoolGoodsTypeEnum == null ? null : netSchoolGoodsTypeEnum.getDesc();
    }

    public static Integer getShopType(Integer goodsTypeValue) {
        NetSchoolGoodsTypeEnum goodsTypeEnum = NetSchoolGoodsTypeEnum.get(goodsTypeValue);
        if (goodsTypeEnum == null) {
            return null;
        }
        switch (goodsTypeEnum) {
            case COURSE: {
                return NetSchoolShopTypeEnum.COURSE.getValue();
            }
            case CLASS: {
                return NetSchoolShopTypeEnum.CLASS.getValue();
            }
            case CLASS_PACK: {
                return NetSchoolShopTypeEnum.CLASS_PACK.getValue();
            }
        }
        return null;
    }

    static {
        CACHE = new HashMap<Integer, NetSchoolGoodsTypeEnum>(3);
        for (NetSchoolGoodsTypeEnum item : NetSchoolGoodsTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }
}

