package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.resp.TagAutoRespDto;

import java.util.List;

/**
 * @author sunwen
 */
public interface ScrmTagAutoService {

    /**
     * 标签自动化配置列表
     *
     * @param bizId 商户id
     * @return 配置列表
     */
    List<TagAutoRespDto> list(Long bizId);

    /**
     * 查询对应的类型的自动标签是否启用
     *
     * @param bizId 商户id
     * @param type 1：购买商品 2：数据渠道 3：客户业务信息
     * @return 0：未启用 1：启用
     */
    Integer queryIsEnableByType(Long bizId, Integer type);
}
