package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum NetSchoolGoodsTypeEnum {
    SCRM(0, "scrm商品"),
    COURSE(1, "课程"),
    CLASS(2, "班级"),
    CLASS_PACK(3, "课时包")
    ;

    private final int value;
    private final String desc;

    NetSchoolGoodsTypeEnum(int id, String name) {
        this.value = id;
        this.desc = name;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, NetSchoolGoodsTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (NetSchoolGoodsTypeEnum item : NetSchoolGoodsTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static NetSchoolGoodsTypeEnum get(Integer status) {
        return CACHE.get(status);
    }

    public static String getDesc(Integer status) {
        NetSchoolGoodsTypeEnum netSchoolGoodsTypeEnum = CACHE.get(status);
        return netSchoolGoodsTypeEnum == null ? null : netSchoolGoodsTypeEnum.getDesc();
    }

    public static Integer getShopType(Integer goodsTypeValue) {
        NetSchoolGoodsTypeEnum goodsTypeEnum = get(goodsTypeValue);
        if (goodsTypeEnum == null){
            return null;
        }
        switch (goodsTypeEnum) {
            case COURSE: //课程
                return NetSchoolShopTypeEnum.COURSE.getValue();
            case CLASS: //班级
                return NetSchoolShopTypeEnum.CLASS.getValue();
            case CLASS_PACK: //课时包
                return NetSchoolShopTypeEnum.CLASS_PACK.getValue();
            default:
                return null;
        }
    }
}