package com.kuaike.scrm.common.service.dto.req.voicematerial;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.enums.voicecall.VoiceMaterialTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Created by chenjiaqiang on 2022/03/02
 **/
@Data
public class VoiceMaterialListReq implements Serializable {

    private static final long serialVersionUID = -5428724201759782432L;

    private String query;

    private Integer type;

    private PageDto pageDto;

    private Long bizId;

    public void validate() {
        Preconditions.checkArgument(pageDto != null, "pageDto不能为空");
        Preconditions.checkArgument(pageDto.getPageNum() != null, "pageNum不能为空");
        Preconditions.checkArgument(pageDto.getPageSize() != null, "pageSize不能为空");
        if (type != null) {
            VoiceMaterialTypeEnum voiceMaterialTypeEnum = VoiceMaterialTypeEnum.get(type);
            Preconditions.checkArgument(voiceMaterialTypeEnum != null, "语音素材类型不存在");
        }
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
    }
}
