package com.kuaike.scrm.common.service.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * desc: 网校课程信息
 *
 * @author yanmaoyuan
 * @date 2023/2/9
 */
@Data
public class NetSchoolGoodsDto implements Serializable {
    private Long bizId;
    private Long id;// 课程id
    private String title;// 课程标题
    @JsonProperty("course_type")
    private Integer courseType;// 课程类型：1一对一, 2大班课, 3小班课, 4公开课, 5点播课, 7面授课, 8音频课,10图文课,15分组课，16线上双师, 22混合课
    @JsonProperty("cover_img")
    private String coverImg;// 封面图
    private Long price;// 价格 单位：分
    private Integer stock;// 原始库存 (0:不限制库存)
    private Integer status;// 课程状态 1已上架 2已下架 3待上架
    @JsonProperty("created_at")
    private Long createdAt;// 课程创建时间 时间戳
    @JsonProperty("updated_at")
    private Long updatedAt;// 课程更新时间 时间戳
    @JsonProperty("course_classify_id")
    private Long courseClassifyId;// 课程分类id
    @JsonProperty("sales_base")
    private Integer salesBase;// 销售基数
    @JsonProperty("sales_num")
    private Integer salesNum;// 售卖数量
    @JsonProperty("browse_base")
    private Integer browseBase;// 浏览基数
    @JsonProperty("browse_num")
    private Integer browseNum;// 浏览量
    private String tag;// 课程标签
    @JsonProperty("section_num")
    private Integer sectionNum;// 课程 总课时 （默认为0）
    @JsonProperty("is_materials")
    private Integer isMaterials;// 课程是否含有材料 （1：有 0：无），含有材料的课程下单需要收货地址
    @JsonProperty("is_go_to_study")
    private Integer isGoToStudy;// 下架后已购买的学员是否可以继续学习（1：可以 0：否）
    @JsonProperty("marketing_language")
    private String marketingLanguage;// 营销语
    @JsonProperty("valid_type")
    private Integer validType;// 课程有效期类型 1长期有效 2按截止日期 3按有效天数
    @JsonProperty("valid_time")
    private Integer validTime;// 课程有效期时间 时间戳
    @JsonProperty("valid_scope")
    private Integer validScope;// 修改学习有效期是否对所有学员生效（1：是 0:否）
    @JsonProperty("school_id")
    private Long schoolId;// 校区id，2：为默认校区
    @JsonProperty("underlined_price")
    private Integer underlinedPrice;// 划线价 单位：分
    private String intro;// 课程简介
    @JsonProperty("course_details")
    private String courseDetails;// 课程详情 HTML富文本
    @JsonProperty("deleted_at")
    private Long deletedAt; // 大于0代表被删除了

    private Integer goodsType; // 1:课程 2:班级
    private Integer action; // 行为 0：新增/更新 1：删除
    private String mainTeacher; // 课程讲师
    private String assitTeacher; // 课程助教
    private Integer showStatus; // 1:隐藏 0:显示
    private Integer saleStatus; // 是否允许单卖 在线购买是否开启/关闭
}
