package com.kuaike.scrm.common.service;


import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.service.dto.req.ScrmProductQueryReq;
import com.kuaike.scrm.common.service.dto.req.ScrmSkuAddReq;
import com.kuaike.scrm.common.service.dto.req.ScrmSkuProductReq;
import com.kuaike.scrm.common.service.dto.resp.ScrmSkuProductResp;
import com.kuaike.scrm.common.service.dto.resp.SpuSimpleInfoResp;

import java.util.List;

/**
 * @author lanye
 */
public interface ScrmSkuService {

    /**
     * 新增商品
     *
     * @param req
     */
    void add(ScrmSkuAddReq req);

    /**
     *  查询商品列表
     * */
    List<ScrmSkuProductResp> queryProductInfoList(ScrmSkuProductReq req);

    /**
     *  根据商品ID 查询商品详情
     * */
    List<ScrmSkuProductResp> queryProductListById(ScrmProductQueryReq req);

    /**
     * 根据商品Id 查询商品sku_no, 如果是三方的返回outProductId，否则返回productId
     **/
    List<String> querySkuNoByProductIds(ScrmProductQueryReq req);

    /**
     * 查询商品简要信息
     *
     * @param bizId 商户id
     * @param productId 商品id
     * @return 商品简明信息
     */
    SpuSimpleInfoResp querySpuSimpleInfo(Long bizId, String productId) throws BusinessException;

    /**
     * 根据productIds查询skuId、outProductId
     *
     * @param productIds
     * @return
     */
    List<String> querySkuOutSkuIdsByProductIds(List<String> productIds);
}
