package com.kuaike.scrm.common.service.dto.resp;

import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.Date;

/**
 * @author sunwen
 */
@Data
public class ContractRespDto implements Serializable {

    /**
     * 交易号
     */
    private String transactionNo;

    /**
     * 合同模板id
     */
    private String templateId;

    /**
     * 合同编号
     */
    private String contractId;

    /**
     * 需要废除的合同编号
     */
    private String originContractId;

    /**
     * 合同状态 1：已签署 2：已废除 3：已归档
     */
    private Integer status;

    private String statusDesc;

    /**
     * 文档标题
     */
    private String docTitle;

    /**
     * 下载地址
     */
    private String downloadUrl;

    /**
     * 预览地址
     */
    private String viewUrl;

    /**
     * 企业客户id
     */
    private String corpCustomerId;

    /**
     * 客户客户id
     */
    private String personalCustomerId;

    /**
     * 合同签署地址
     */
    private String fddSignUrl;

    /**
     * 签署地址生成时间
     */
    private Date signUrlCreateTime;

    /**
     * 企业签署状态 0:未签 1:已签
     */
    private Integer corpSignStatus;

    /**
     * 客户签署状态 0:未签 1:已签
     */
    private Integer personalSignStatus;

    private String signTime;

    /**
     * 合同类别 1:正常 2:已废除
     */
    private Integer contractType;

    /**
     * 合同是否已归档 0:否 1:是
     */
    private Integer isArchived;

    /**
     * 备注
     */
    private String remark;

    /**
     * 业务数据类型 1:订单
     */
    private Integer businessDataType;

    /**
     * 业务数据id
     */
    private Long businessDataId;

    /**
     * 业务数据编号
     */
    private String businessDataNo;
}
