package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author lanye
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ScrmSkuItemDto implements Serializable {
    /**
     * 更新时传
     */
    String productId;

    /**
     * 更新时传
     */
    String skuId;

    /**
     * 商家自定义商品ID，最多32字符
     */
    String outProductId;

    /**
     * 商家自定义skuID，最多32字符
     */
    String outSkuId;

    /**
     * sku小图
     */
    String thumbImg;

    /**
     * 售卖价格，以分为单位，不超过1000000000（1000万元）
     */
    Long salePrice;

    /**
     * 非必填 市场价格,以分为单位，不超过1000000000（1000万元），必须比sale_price大
     */
    Long marketPrice;

    /**
     * 库存
     */
    Long stockNum = 9999999L;

    /**
     * 商品编码，最多20字符
     */
    String skuCode;

    /**
     * 条形码
     */
    String barCode;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(outProductId) && StringUtils.length(outProductId) <= 32, "outProductId不能为空,且最大长度为32");

        Preconditions.checkArgument(StringUtils.isNotBlank(outSkuId) && StringUtils.length(outSkuId) <= 32, "outSkuId不能为空,且最大长度为32");

        Preconditions.checkArgument(Objects.nonNull(salePrice) && salePrice >= 0L && salePrice <= 1000000000L * 10000, "salePrice以毫为单位，不超过1000000000");

        if (Objects.nonNull(marketPrice)) {
            Preconditions.checkArgument(marketPrice >= 0L && marketPrice <= 1000000000L * 10000, "marketPrice以毫为单位，不超过1000000000");
            Preconditions.checkArgument(marketPrice >= salePrice, "marketPrice必须比salePrice大");
        }

        Preconditions.checkArgument(Objects.nonNull(stockNum) && stockNum > 0, "stockNum不能为空");
    }
}
