package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.OrgUserDto;
import com.kuaike.scrm.common.service.dto.WeworkUserInfo;
import com.kuaike.scrm.common.service.dto.resp.UserBehaviorDataResp;

import java.util.*;

public interface ScrmWeworkUserService {
    /**
     * 根据组织架构节点id获取成员
     */
    List<OrgUserDto> getOrgOfWeworkUser(List<Long> deptIds);

    /**
     * 根据weworkUserId查询成员信息，去掉已删除的
     **/
    List<WeworkUserInfo> getWeworkUserInfo(String corpId, List<String> weworkUserIds);

    WeworkUserInfo getWeworkUserInfo(String weworkUserNum);

    /**
     *  weworkUserIds 密文转明文接口
     * */
    Map<String, String> queryWeworkUserIdsBy(Long bizId, List<String> weworkUserIds);


    Map<String, String> queryWeworkUserIdByNums(Long bizId, Collection<String> weworkUserNums);

    Map<String, String> queryWeworkUserNumByWeworkUserIds(Long bizId, Collection<String> weworkUserIds);

    List<UserBehaviorDataResp> pullUserBehaviorData(Long bizId, Date startTime, Date endTime, Collection<String> weworkUserIds);

    /**
     * 时间段内 超时未回复的次数
     */
    Map<String, Integer> queryTimeoutUnReply(Long bizId, Date startTime, Date endTime, Collection<String> weworkUserIds);
}
