package com.kuaike.scrm.common.service.dto.resp;

import com.kuaike.scrm.common.dto.NodeInfo;
import lombok.Data;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

/**
 * 用户基本信息
 *
 * @author yanmaoyuan
 * @date 2021/9/5
 */
@Data
public class UserSimpleInfo implements Serializable {

    // 用户ID
    private Long id;
    // 用户唯一编码
    private String num;
    // 用户名称
    private String name;
    // 当前用户所属的部门ID
    private Long nodeId;
    private String nodeName;
    // 用户的企业微信ID（可能为空）
    private String weworkUserId;

    // 企业可以自定义的唯一标识，例如工号、手机号、邮箱等。大小写敏感。默认值与num相同
    private String identifier;

    private List<List<NodeInfo>> fullNodeInfo;
}
