package com.kuaike.scrm.common.service.dto.req.customeracquisition;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author Created by chenjiaqiang on 2023/05/10
 **/
@Data
public class CreateShareRecordReq implements Serializable {

    private String customerAcquisitionLinkNum;

    /**
     * 1 广告投放
     */
    private Integer fkType;

    /**
     * 1、广告投放 落地页number
     */
    private String fkId;

    /**
     * 1、广告投放 分配规则number
     */
    private String fkDetailId;

    private String channelNum;

    private String mobile;

    private String weworkUserId;

    private String contactId;

    public void validate() {
        Preconditions.checkArgument(fkType != null, "fkType不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(customerAcquisitionLinkNum), "获客链接num不能为空");
    }

}
