package com.kuaike.scrm.common.service.dto;


import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class LeadsAllocRemindReq implements Serializable {
    private Long bizId;

    private String corpId;

    private String batchNo;

    private Integer notifyType;

    private String weworkUserNum;

    private String weworkUserId;

    private Integer leadsCount;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(weworkUserNum), "发送成员不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(batchNo), "批次号不能为空");
        Preconditions.checkArgument(notifyType != null, "通知类型不能为空");
        Preconditions.checkArgument(leadsCount > 0, "线索数量要大于0");
    }
}
