package com.kuaike.scrm.common.service.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author lanye
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CustomerDto implements Serializable {

    /**
     * 手机号
     */
    private String phone;

    /**
     * 名称
     */
    private String name;

    private Long userId;

    public CustomerDto(String phone, String name) {
        this.phone = phone;
        this.name = name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CustomerDto) {
            CustomerDto c = (CustomerDto) obj;
            return phone.equals(c.phone);
        }
        return false;
    }

    @Override
    public int hashCode() {
        String in = phone;
        return in.hashCode();
    }

}
