package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.dto.WeworkTagMsg;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 企业微信客户标签
 *
 * <p>企业微信客户标签，以标签组为单位管理，标签组之间不重名。每个标签组下有多个标签，一个组内的标签不可重名。例如: 性别:男,女; 地区:北京,成都,武汉;</p>
 *
 * <p>标签ID为企业微信加密后的字符串，长度为32字节，大小写敏感。例如: <code>etHh4aBgAAXPjo2Ja80OLe0rgyjoNSfw</code>。</p>
 *
 * <p>根据企业微信API的使用方法，标签ID应该是全局唯一的。详见<a href="https://open.work.weixin.qq.com/api/doc/90000/90135/92118">编辑客户企业标签</a>接口。</p>
 *
 * @author yanmaoyuan
 * @date 2021/9/14
 */
public interface ScrmTagService {

    /**
     * 根据标签ID，查询标签名称
     *
     * @param corpId 商户ID
     * @param ids 标签ID
     * @return key:标签ID, value:标签名
     */
    Map<String, String> getNameByIds(String corpId, Collection<String> ids);

    /**
     * 根据标签组和标签，返回标签id。不存在创建，存在直接返回。
     *
     * @param bizId 必传
     * @param groupName 必传
     * @param tagName 必传
     * @return 标签Id
     **/
    String getTagIdByNames(Long bizId, String groupName, String tagName);

    /**
     * 给所有成员的contactId客户打上标签
     * @param bizId
     * @param contactId
     */
    void attachTagByContactId(Long bizId, String contactId, List<String> addTags, List<String> rmTags);


    /**
     *  查询客户身上的所有标签
     * */
    Map<String, List<String>> getTagIdsByContact(Long bizId, List<String> contactIds);

    Map<String, String> batchGetTagIdByNames(Long bizId, String groupName, Set<String> tagNames);


    /**
     *  所有成员的标签同步
     * */
    void contactTagSync(WeworkTagMsg msg);
}
