package com.kuaike.scrm.common.service;


import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.service.dto.AppSmsRespDto;
import com.kuaike.scrm.common.service.dto.req.ScrmSendSmsReqDto;
import com.kuaike.scrm.common.service.dto.req.SmsSendReqDto;
import com.kuaike.scrm.common.service.dto.resp.SmsCountRespDto;
import com.kuaike.scrm.common.service.dto.resp.SmsRecordDto;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author lanye
 */
public interface ScrmSmsService {


    /**
     * 短信发送记录
     *
     * @param phones
     * @param pageDto
     * @return
     */
    AppSmsRespDto recordList(List<String> phones, PageDto pageDto);

    /**
     * 短信发送记录
     *
     * @param phone
     * @param pageDto
     * @return
     */
    AppSmsRespDto recordList(String phone, PageDto pageDto);

    /**
     * 发送自定义营销短息
     *
     * @param reqDto 请求参数
     * @return 短信任务详情id
     */
    Long sendCustomSms(ScrmSendSmsReqDto reqDto);

    /**
     * 发送通知短息，用于电子合同
     *
     * @param reqDto 请求参数
     * @return 短信任务详情id
     */
    Long sendNoticeSms(ScrmSendSmsReqDto reqDto);

    /**
     * 批量发送通知短息，用于电子合同
     *
     * @param reqDto 请求参数
     * @return 短信任务详情id
     */
    Long sendNoticeSmsBatch(ScrmSendSmsReqDto reqDto);

    /**
     * 根据任务详情ids获取对应的发送状态
     *
     * @param ids 任务请求id集合
     * @return key:任务详情id value:任务发送状态
     */
    Map<Long, Integer> getSendStatusBySmsTaskDetailIds(Collection<Long> ids);

    /**
     * 短信记录统计
     **/
    List<SmsCountRespDto> smsCount(SmsSendReqDto reqDto);

    /**
     * 根据时间范围查询记录
     */
    List<SmsRecordDto> recordListByTime(Long bizId, Collection<String> phones, Date startTime, Date endTime);
}
