package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.LeadsAllocRemindReq;
import com.kuaike.scrm.common.service.dto.req.ScrmAddRemindReqDto;
import com.kuaike.scrm.common.service.dto.req.ScrmModRemindReqDto;
import com.kuaike.scrm.common.service.dto.RemindMsgDto;
import java.util.List;

/**
 * 对外暴露添加企微提醒功能
 */
public interface ScrmRemindService {
    /*
     *  weworkUserNums 发送的成员
     *  sendContent   文本消息内容
     * */
    void sendMsg(String corpId, List<String> weworkUserNums, String sendContent);

    /**
     *  调用企微接口  发送文本消息
     *  corpId
     *  target    消息接收者，多个接收者用‘|’分隔，最多支持1000个
     *  sendContent   文本消息内容
     * */
    void sendMsg(String corpId, String target, String sendContent);

    /**
     *  调用企微接口  发送图文消息
     *  corpId
     *  weworkUserNums 发送的成员
     *  msgDtos   图文消息内容
     * */
    void sendNewMsg(String corpId, List<String> weworkUserNums, List<RemindMsgDto> msgDtos);

    /**
     *  新增百家云提醒
     * */
    void addRemind(ScrmAddRemindReqDto reqDto);

    /**
     *  修改百家云提醒
     * */
    void modRemind(ScrmModRemindReqDto reqDto);


    /**
     * crm线索分配提醒
     */
    void leadsAllocRemind(LeadsAllocRemindReq req);
}
