package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.req.ModMobileSyncReq;
import com.kuaike.scrm.common.service.dto.req.ScrmMarkWeworkTagReqDto;
import com.kuaike.scrm.common.service.dto.resp.*;

import java.util.*;

/**
 * 根据手机号，查询企业客户的接口
 *
 * @author yanmaoyuan
 * @date 2021/9/24
 */
public interface ScrmContactService {

    /**
     * 根据手机号查询企业客户
     *
     * @param corpId 企业ID
     * @param mobile 手机号
     */
    WeworkContactResp search(String corpId, String mobile);

    /**
     * 根据手机号查询企业客户
     *
     * @param corpId  企业ID
     * @param mobiles 手机号
     */
    List<WeworkContactResp> search(String corpId, Collection<String> mobiles);

    List<ContactAssociateResp> queryContactAssociate(String corpId, String customerNum, List<String> mobiles);

    /**
     * 根据appId查询公众号信息
     *
     * @param appId appId
     * @return
     */
    OfficialResp official(String appId);

    /**
     * 根据appId查询小程序信息
     *
     * @param appId appId
     * @return
     */
    AppletResp miniProgram(String appId);

    /**
     * crm打标签同步企微
     *
     * @param scrmMarkWeworkTagReqDto scrmMarkWeworkTagReqDto
     * @return
     */
    void markWeworkTag(ScrmMarkWeworkTagReqDto scrmMarkWeworkTagReqDto);


    /**
     * 手机号互通，同步到所有成员给客户的备注手机号上
     */
    void modMobileByAllWeworkUserIds(ModMobileSyncReq req);

    /**
     * 根据weworkDigitIds获取CustomerNum
     *
     * @param bizId
     * @param weworkDigitIds
     * @return
     */
    Map<String, String> getCustomerNumByWeworkDigitIds(Long bizId, Collection<String> weworkDigitIds);

    /**
     * 根据CustomerNum获取weworkDigitIds
     *
     * @param bizId
     * @param customerNums
     * @return
     */
    Map<String, String> getWeworkDigitIdsByCustomerNum(Long bizId, Collection<String> customerNums);


    String getContactIdByUnionId(String corpId, String unionId);

    /**
     * 根据成员客户的好友关系过滤出是好友的contactId
     * @return
     */
    List<String> filterContactIdByWeworkUserNum(String weworkUserNum, List<String> contactIds);

    /**
     * 查询时间段内加过好友的记录（不排除已删除好友的记录）
     */
    Map<String, Set<String>> queryIsAddedFriendByContactIdsAndAddTime(Long bizId, Collection<String> contactIds, Date startTime, Date endTime);

    /**
     * 查询wework_contact_log表
     * 时间段内 删除的contactId
     */
    List<DeletedWeworkContactResp> queryDeletedByTimeRange(Long bizId, Date startTime, Date endTime, Collection<String> weworkUserNums);

    /**
     * 查询wework_contact_relation 表中好友数量
     * */
    Map<String, Integer> queryAddFriendCountByContactIds(Long bizId, List<String> contactIds);
}