package com.kuaike.scrm.common.service;


import com.alibaba.fastjson.JSONArray;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.service.dto.AppCallRespDto;
import com.kuaike.scrm.common.service.dto.req.AppCalledReqDto;
import com.kuaike.scrm.common.service.dto.req.ScrmCallOutReq;
import com.kuaike.scrm.common.service.dto.req.voicematerial.*;
import com.kuaike.scrm.common.service.dto.resp.AppCalledRespDto;
import com.kuaike.scrm.common.service.dto.resp.CallRecordDto;
import com.kuaike.scrm.common.service.dto.resp.call.AppConfigRespDto;
import com.kuaike.scrm.common.service.dto.resp.call.DubboCallRecordRespDto;
import com.kuaike.scrm.common.service.dto.resp.voicematerial.CreateVoiceCallResp;
import com.kuaike.scrm.common.service.dto.resp.voicematerial.VoiceMaterialDetailResp;
import com.kuaike.scrm.common.service.dto.resp.voicematerial.VoiceMaterialListResp;

import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * @author lanye
 */
public interface ScrmCallService {

    /**
     * 通话记录
     *
     * @param phones
     * @param pageDto
     * @return
     */
    AppCallRespDto recordList(List<String> phones, PageDto pageDto);

    /**
     * 通话记录
     *
     * @param phone
     * @param pageDto
     * @return
     */
    AppCallRespDto recordList(String phone, PageDto pageDto);

    /**
     * 通话记录
     *
     * @param nums
     * @return
     */
    List<CallRecordDto> recordList(List<String> nums);

    /**
     * 通过手机号和时间范围
     * 查询通话记录
     */
    List<CallRecordDto> recordListByTime(Long bizId, Collection<String> mobiles, Date statTime, Date endTime);

    /**
     * 根据批次号查询通话记录
     *
     * @param batchId
     * @return
     */
    AppCallRespDto queryRecordByBatchId(String batchId);

    /**
     * 是否呼叫过
     *
     * @param reqDto
     * @return
     */
    List<AppCalledRespDto> called(AppCalledReqDto reqDto);

    /**
     * 呼出
     *
     * @return
     */
    String callOut(ScrmCallOutReq params);

    /**
     * 查询外呼记录的语音通话记录
     *
     * @param bizId
     * @param voiceUrl
     * @return
     */
    String getFullVoiceUrl(Long bizId, String voiceUrl);

    /**
     * 查询商户的外呼配置
     *
     * @param bizId
     * @return
     */
    boolean isOpen(Long bizId);

    /**
     * 商户是否开通语音外呼
     *
     * @param bizId
     * @return
     */
    boolean isOpenVoice(Long bizId);

    /**
     * 新增语音素材
     *
     * @param req
     * @return
     */
    String addVoiceMaterial(AddVoiceMaterialReq req);

    /**
     * 语音素材详情
     *
     * @param req
     * @return
     */
    VoiceMaterialDetailResp voiceMaterialDetail(VoiceMaterialIdReq req);

    /**
     * 编辑语音素材
     *
     * @param req
     */
    void editVoiceMaterial(EditVoiceMaterialReq req);

    /**
     * 删除语音素材
     *
     * @param req
     */
    void delVoiceMaterial(VoiceMaterialIdReq req);

    /**
     * 语音素材列表
     *
     * @param req
     * @return
     */
    VoiceMaterialListResp voiceMaterialList(VoiceMaterialListReq req);

    /**
     * 新建语音外呼任务
     *
     * @param req
     * @return
     */
    CreateVoiceCallResp createVoiceCall(CreateVoiceCallReq req);

    /**
     * 通话统计
     *
     * @param reqDto
     * @return
     */
    List<AppCalledRespDto> callCount(AppCalledReqDto reqDto);

    /**
     * 以userId 维度，批量查询通话记录
     *
     * @param reqDto
     * @return
     */
    List<AppCalledRespDto> batchCallCount(AppCalledReqDto reqDto);

    /**
     * 账号配置
     *
     * @param bizId
     * @param userId
     * @return
     */
    AppConfigRespDto config(Long bizId, Long userId);

    /**
     * 坐席状态
     *
     * @param bizId
     * @param userId
     * @return
     */
    DubboCallRecordRespDto detail(Long bizId, Long userId);

    /**
     * 空闲坐席
     *
     * @param bizId
     * @param userId
     * @return
     */
    JSONArray freeExten(Long bizId, Long userId);

    /**
     * 获取SessionId
     *
     * @param bizId
     * @param userId
     * @return
     */
    String getCallSessionId(Long bizId, Long userId);

    /**
     * 签入签出
     *
     * @param bizId
     * @param userId
     * @param signInType
     */
    void signInOrOut(Long bizId, Long userId, Integer signInType);

    /**
     * 接通话登记
     *
     * @param bizId
     * @param userId
     * @param callType
     * @param callSheetId
     */
    void register(Long bizId, Long userId, String callType, String callSheetId);
}
