/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ContractStatus {
    SIGNED(1, "\u5df2\u7b7e\u7f72"),
    ABANDONED(2, "\u5df2\u5e9f\u9664"),
    ARCHIVED(3, "\u5df2\u5f52\u6863");

    private final int value;
    private final String desc;
    private static final Map<Integer, ContractStatus> CACHE;

    private ContractStatus(int id, String name) {
        this.value = id;
        this.desc = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ContractStatus get(Integer status) {
        return CACHE.get(status);
    }

    static {
        CACHE = new HashMap<Integer, ContractStatus>(3);
        for (ContractStatus item : ContractStatus.values()) {
            CACHE.put(item.getValue(), item);
        }
    }
}

