package com.kuaike.scrm.common.service.dto.req.voicematerial;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.voicecall.VoiceMaterialTypeEnum;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author Created by chenjiaqiang on 2022/03/02
 **/
@Data
public class EditVoiceMaterialReq implements Serializable {

    private static final long serialVersionUID = -2175963350922403168L;

    private String id;

    private String name;

    private String fileName;

    private Integer type;

    private String content;

    private Long bizId;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(id), "id不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "素材名称不能为空");
        Preconditions.checkArgument(name.length() <= 50, "素材名称超长");
        Preconditions.checkArgument(type != null, "素材类型不能为空");
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        VoiceMaterialTypeEnum voiceMaterialTypeEnum = VoiceMaterialTypeEnum.get(type);
        Preconditions.checkArgument(voiceMaterialTypeEnum != null, "素材类型不存在");
        Preconditions.checkArgument(StringUtils.isNotBlank(content), "素材内容不能为空");
    }

}
