package com.kuaike.scrm.common.service.dto.req;

import lombok.Data;
import java.io.Serializable;
import java.util.List;

/**
 * @Date: 2021/6/3 19:17
 * @Author: dayu
 */
@Data
public class ScrmModRemindReqDto implements Serializable {

    /**
     * 业务类型 1:会议提醒 2:群发提醒
     */
    private Integer bizType;

    /**
     * 提醒类型 1:单次提醒 2:周期提醒
     */
    private Integer remindType;

    /**
     * 提醒内容
     */
    private String content;

    /**
     * 业务数据id，结合biz_type使用
     */
    private Long fkId;

    /**
     * 业务关联表的创建人
     */
    private Long fkCreateBy;

    /**
     * 会议类型 1:外部培训  2: 内部会议
     * 非会议类型 为 0
     */
    private Integer meetingType;

    /**
     *  提醒详情
     * */
    private List<ScrmRemindDetailReqDto> remindDetailReqDtos;

}
