package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@AllArgsConstructor
@NoArgsConstructor
@Data
public class NoticeQueryReq implements Serializable {

    private static final long serialVersionUID = 3716702973263162739L;

    private Long userId;

    private Integer haveDeal;

    private Integer type;

    private PageDto pageDto;

    private Date startTime;

    private Date endTime;

    private Date date;

    public void validate() {
        Preconditions.checkArgument(userId != null, "userId不能为空");
    }

}
