package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.OfficialMsgTypeEnum;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

@Data
public class SendOfficialMsgReq implements Serializable {

    private Long bizId;

    private Set<String> unionIds;

    /**
     * @see com.kuaike.scrm.common.enums.OfficialMsgTypeEnum
     */
    private Integer msgType;

    /**
     * 所需跳转到的小程序appid（该小程序appid必须与发模板消息的公众号是绑定关联关系，暂不支持小游戏）
     */
    private String appId;

    /**
     * 所需跳转到小程序的具体页面路径，支持带参数,（示例index?foo=bar），要求该小程序已发布，暂不支持小游戏
     */
    private String pagePath;

    /**
     * 老师点评通知、模考成绩通知、作业提交通知、排名通知用到的字段
     */
    private String content;

    /***开课通知需要用到的字段****/
    private String teacherName; // 任课教师

    private String classSchedule; // 上课时间

    private String courseName; // 课程名称

    private String address; // 上课地点

    private String studentName; //学生姓名

    private  String orderNum;

    private String totalAmount;

    private String orderCreateTime;

    public void validateParams() {
        Preconditions.checkArgument(Objects.nonNull(bizId), "商户id不能为空");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(unionIds), "unionIds不能为空");
        Preconditions.checkArgument(Objects.nonNull(msgType), "消息类型不能为空");
        Preconditions.checkArgument(Objects.nonNull(OfficialMsgTypeEnum.get(msgType)), "消息类型值不合法");
    }
}
