package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.resp.StageDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 阶段信息查询接口
 *
 * @author yanmaoyuan
 * @date 2021/9/18
 */
public interface ScrmStageService {

    /**
     * 根据ID批量查询阶段信息
     *
     * @param bizId 商户ID
     * @param ids 阶段ID
     * @return 阶段
     */
    List<StageDto> getByIds(Long bizId, Collection<Long> ids);

    /**
     * 根据ID批量查询阶段信息
     *
     * @param bizId 商户ID
     * @param ids 阶段ID
     * @return key:阶段id, value:阶段
     */
    Map<Long, StageDto> getMapByIds(Long bizId, Collection<Long> ids);

    /**
     * 根据ID查询阶段信息
     *
     * @param bizId 商户ID
     * @param id 阶段ID
     * @return 阶段
     */
    StageDto getById(Long bizId, Long id);

    /**
     * 查询初始阶段
     *
     * @param bizId 商户ID
     * @return 初始阶段
     */
    StageDto getFirstStage(Long bizId);

    /**
     * 查询最终阶段
     *
     * @param bizId 商户ID
     * @return 最终阶段
     */
    StageDto getLastStage(Long bizId);

    /**
     * 查询所有阶段
     *
     * @param bizId 商户ID
     * @return 阶段列表
     */
    List<StageDto> getAllStage(Long bizId);

    Map<Long, Integer> getStageIndex(Long bizId);
}
