package com.kuaike.scrm.common.service;

import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.service.dto.req.ContractSignReqDto;
import com.kuaike.scrm.common.service.dto.req.CreateContractReqDto;
import com.kuaike.scrm.common.service.dto.resp.ContractRespDto;
import com.kuaike.scrm.common.service.dto.resp.ContractSignRespDto;

import java.util.Set;

/**
 * @author sunwen
 */
public interface ScrmContractService {

    /**
     * 注册个人帐号
     *
     * @param bizId 商户id
     * @param corpId 企业id
     * @param fddOpenId 个人唯一标识
     * @return 客户id
     */
    String registerCustomerAccount(Long bizId, String corpId, String fddOpenId);

    /**
     * 判断商户是否已完成自动签授权
     *
     * @param bizId 商户id
     * @return false:企业还未授权 true:企业已授权
     */
    boolean isCorpAutoSignAuthorized(Long bizId);

    /**
     * 获取模板中的文本域的名称
     *
     * @param bizId 商户id
     * @param corpId 企业id
     * @param templateId 模板id
     * @param templateType 模板类型 1：普通模板 2：废除模板
     * @return 模板对应的文本域名称集合
     */
    Set<String> getTemplateKeys(Long bizId, String corpId, String templateId, Integer templateType) throws BusinessException;

    /**
     * 生成合同
     *
     * @param reqDto 请求参数对象
     * @return 合同信息对象
     */
    ContractRespDto createContract(CreateContractReqDto reqDto) throws BusinessException;

    /**
     * 废除合同
     *
     * @param bizId 商户id
     * @param contractId 合同id
     */
    void abandonContract(Long bizId, String contractId);

    /**
     * 发起签署
     *
     * @param reqDto 请求参数
     * @return 签署信息
     */
    ContractSignRespDto getContractSignUrl(ContractSignReqDto reqDto) throws BusinessException;

    /**
     * 当前商户是否开通电子合同
     *
     * @param bizId 商户id
     * @return true:开通 false:未开通
     */
    boolean isOpenedContract(Long bizId);

    /**
     * 获取商户下的可用余额
     *
     * @param bizId 商户id
     * @return 商户可用余额
     */
    int getAccountRestMoney(Long bizId);

    /**
     * 转移合同
     *
     * @param bizId 商户id
     * @return 商户可用余额
     */
    void transferContract(Long bizId, String contractId, String newOrderNo, Long newOrderId);
}
