package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 成单分校类型
 */
public enum SalesNodeTypeEnum {
    A("A", "A"),

    B("B", "B");

    private final String value;
    private final String name;

    SalesNodeTypeEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return name;
    }

    private static final Map<String, SalesNodeTypeEnum> cache;

    static {
        cache = new HashMap<>();
        for (SalesNodeTypeEnum item : SalesNodeTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static SalesNodeTypeEnum get(String value) {
        return cache.get(value);
    }
}
