package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum OfficialMsgTypeEnum implements EnumService {

    TEACHER_FEEDBACK_NOTICE(0, "老师点评通知", "考试成绩通知"),

    MOCK_EXAM_SCORE_NOTICE(1, "模考成绩通知", "考试成绩通知"),

    ASSIGNMENT_SUBMISSION_NOTICE(2, "作业提交通知", "考试提醒"),

    COURSE_COMMENCEMENT_NOTICE(3, "开课通知", "预约上课成功通知"),

    RANKING_NOTICE(4, "排名通知", "考试成绩通知"),

    ORDER_NOTICE(5, "下单通知", "订单创建成功通知");

    private final int value;
    private final String name;
    private final String templateName;

    OfficialMsgTypeEnum(int value, String name, String templateName) {
        this.value = value;
        this.name = name;
        this.templateName = templateName;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }

    public String getTemplateName() {
        return templateName;
    }

    private static final Map<Integer, OfficialMsgTypeEnum> cache;

    static {
        cache = new HashMap<>();
        for (OfficialMsgTypeEnum item : OfficialMsgTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static OfficialMsgTypeEnum get(Integer value) {
        return cache.get(value);
    }
}
