package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author sunwen
 */
@Data
public class ScrmSendSmsReqDto implements Serializable {

    private Long bizId;

    private String corpId;

    private String content;

    private Long userId;

    private String mobile;

    public void validateParams() {
        Preconditions.checkArgument(Objects.nonNull(bizId), "商户id不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "企业id不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(content), "发送内容不能为空");
        Preconditions.checkArgument(Objects.nonNull(userId), "用户id不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(mobile), "手机号不能为空");
    }
}
