package com.kuaike.scrm.common.service.dto;

import lombok.Data;

import java.io.Serializable;


/**
 * 附件消息
 */
@Data
public class AttachmentDto implements Serializable {
    private static final long serialVersionUID = 1872319669183541525L;
    /**
     * 消息类型
     * image
     * video
     * link
     * miniprogram  小程序
     */
    private String msgType;

    /**
     * 链接
     */
    private String url;

    /**
     * 链接封面ur， jpg或者png
     */
    private String picUrl;

    /**
     * 链接标题， 或者小程序标题
     */
    private String title;

    /**
     * 描述
     */
    private String desc;

    /**
     * 小程序的appId
     */
    private String appId;

    /**
     * 小程序页面地址
     */
    private String page;

    /**
     * 图片的media_id
     **/
    private String imageMediaId;
}
