package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.resp.OrgRespDto;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ScrmUserService {

    /**
     * 获取用户id对应的用户名称
     *
     * @param ids 用户id集合
     * @return key:用户id value:用户名称
     */
    Map<Long, String> getNameByIds(Collection<Long> ids);

    /**
     * 根据num获得用户ID
     *
     * @param num 用户num
     * @return 用户ID
     */
    Long getIdByNum(String num);

    /**
     * 根据id获取num
     *
     * @param id 用户ID
     * @return 用户num
     */
    String getNumById(Long id);

    /**
     * 根据ID查询用户信息
     *
     * @param id 用户ID
     * @return 用户信息
     */
    UserSimpleInfo getById(Long id);

    /**
     * 根据id获取num
     *
     * @param ids 用户ID集合
     * @return key:用户id value:用户num
     */
    List<UserSimpleInfo> getUserInfoByIds(Collection<Long> ids);

    /**
     * 根据id获取num
     *
     * @param nums 用户num集合
     * @return key:用户id value:用户信息
     */
    List<UserSimpleInfo> getUserInfoByNums(Collection<String> nums);

    /**
     * 根据部门ID查询用户ID
     *
     * @param nodeIds 组织架构ID
     * @return 用户ID
     */
    Set<Long> queryIdsByNodeIds(Collection<Long> nodeIds);

    /**
     * 获取用户角色对应的组织类型
     *
     * @param roleId 角色id
     * @return 组织类型 1：总部 2：分校
     */
    Integer getUserRoleOrgType(Long roleId);

    /**
     * 根据员工的唯一标识查询用户ID
     *
     * @param bizId      商户ID
     * @param identifier 用户自定义的唯一标识，可以是工号、手机号、邮箱等。大小写敏感。
     * @return 用户ID
     */
    Long getIdByIdentifier(Long bizId, String identifier);

    /**
     * 根据员工的唯一标识查询用户ID
     *
     * @param bizId       商户ID
     * @param identifiers 用户自定义的唯一标识。
     * @return key:自定义唯一标识 value:用户ID
     */
    Map<String, Long> getIdByIdentifiers(Long bizId, Collection<String> identifiers);

    /**
     * 根据员工唯一标识，查询用户基本信息
     *
     * @param bizId      商户ID
     * @param identifier 用户自定义的唯一标识，可以是工号、手机号、邮箱等。大小写敏感。
     * @return 用户ID
     */
    UserSimpleInfo getUserInfoByIdentifier(Long bizId, String identifier);

    /**
     * @param bizId       商户ID
     * @param identifiers 用户自定义的唯一标识。
     * @return
     */
    List<UserSimpleInfo> getUserInfoByIdentifiers(Long bizId, Collection<String> identifiers);


    /**
     * 根据userId获取weworkUserId
     **/
    String getWeworkUserIdByUserId(Long userId);

    /**
     * 批量查询userId, weworkUserId
     **/
    Map<Long, String> getUserIdWeworkUserIdMap(Collection<Long> userIds);

    /**
     * 根据userId查询weworkUserNum
     **/
    String getWeworkUserNumByUserId(Long userId);

    /**
     * 获取用户所属分校/总部
     *
     * @param userId 用户id
     * @return 分校/总部信息
     */
    OrgRespDto getBelongSchoolOrHeadOffice(Long userId);

    /**
     * 根据用户id和角色名获取对应的企微成员id集合
     *
     * @param corpId   企业id
     * @param userId   用户id
     * @param roleName 角色名称
     * @return 用户对应的企微成员id集合
     */
    Set<String> getWeworkUserIdsByUserIdAndRoleName(String corpId, Long userId, String roleName);

    /**
     * 根据企业id、角色名获取对应的企微用户id
     *
     * @param corpId    企业id
     * @param roleNames 角色名集合
     * @return key:角色名 value:角色对应的用户的企微id
     */
    Map<String, List<String>> getWeworkUserIdsByRoleName(String corpId, Set<String> roleNames);

    /**
     * 根据企业id、用户id、角色名获取对应的企微用户id
     *
     * @param corpId    企业id
     * @param userId    用户id
     * @param roleNames 角色名集合
     * @return key:角色名 value:角色对应的用户的企微id
     */
    Map<String, List<String>> getRoleNameWeworkUserIdsByUserIdAndRoleNames(String corpId, Long userId, Set<String> roleNames);

    /**
     * 根据成员唯一标识，查询用户基本信息
     *
     * @param bizId         商户ID
     * @param weworkUserNum weworkUserNum
     * @return 用户
     */
    UserSimpleInfo getUserInfoByWeworkUserNum(Long bizId, String weworkUserNum);
}