package com.kuaike.scrm.common.service;

import java.util.Collection;
import java.util.Map;

/**
 * 企业微信客户标签
 *
 * <p>企业微信客户标签，以标签组为单位管理，标签组之间不重名。每个标签组下有多个标签，一个组内的标签不可重名。例如: 性别:男,女; 地区:北京,成都,武汉;</p>
 *
 * <p>标签ID为企业微信加密后的字符串，长度为32字节，大小写敏感。例如: <code>etHh4aBgAAXPjo2Ja80OLe0rgyjoNSfw</code>。</p>
 *
 * <p>根据企业微信API的使用方法，标签ID应该是全局唯一的。详见<a href="https://open.work.weixin.qq.com/api/doc/90000/90135/92118">编辑客户企业标签</a>接口。</p>
 *
 * @author yanmaoyuan
 * @date 2021/9/14
 */
public interface ScrmTagService {

    /**
     * 根据标签ID，查询标签名称
     *
     * @param corpId 商户ID
     * @param ids 标签ID
     * @return key:标签ID, value:标签名
     */
    Map<String, String> getNameByIds(String corpId, Collection<String> ids);
}
