package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.req.RoleAddReqDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author sunwen
 */
public interface ScrmRoleService {

    /**
     * 初始化系统角色
     *
     * @param roleAddReqDtos 请求参数对象
     */
    void initSystemRoles(List<RoleAddReqDto> roleAddReqDtos);

    /**
     * 根据企业id和角色名获取对应的企微成员weworkUserId集合
     *
     * @param roleName 角色名称
     * @return 企微成员weworkUserId集合
     */
    Set<String> getWeworkUserIdsByRoleName(String corpId, String roleName);

    /**
     * 根据系统内置角色名称获取对应的角色id
     *
     * @param corpId 企业id
     * @param roleNames 角色名称集合
     * @return key:角色名称 value:角色id
     */
    Map<String, Long> getRoleIdByRoleNames(String corpId, Set<String> roleNames);

    /**
     * 获取角色对应的组织架构类型
     *
     * @param corpId 企业id
     * @param roleName 角色名
     * @return null未配置 1：总部 2：分校
     */
    Integer getRoleOrgTypeByRoleName(String corpId, String roleName);
}
