package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ContractStatus {
    SIGNED(1, "已签署"),
    ABANDONED(2, "已废除"),
    ARCHIVED(3, "已归档");

    private final int value;
    private final String desc;

    ContractStatus(int id, String name) {
        this.value = id;
        this.desc = name;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ContractStatus> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (ContractStatus item : ContractStatus.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static ContractStatus get(Integer status) {
        return CACHE.get(status);
    }
}