package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ScrmUserService {

    /**
     * 获取用户id对应的用户名称
     *
     * @param ids 用户id集合
     * @return key:用户id value:用户名称
     */
    Map<Long, String> getNameByIds(Collection<Long> ids);

    /**
     * 根据num获得用户ID
     * @param num 用户num
     * @return 用户ID
     */
    Long getIdByNum(String num);

    /**
     * 根据id获取num
     *
     * @param id 用户ID
     * @return 用户num
     */
    String getNumById(Long id);

    /**
     * 根据id获取num
     *
     * @param ids 用户ID集合
     * @return key:用户id value:用户num
     */
    List<UserSimpleInfo> getUserInfoByIds(Collection<Long> ids);

    /**
     * 根据id获取num
     *
     * @param nums 用户num集合
     * @return key:用户id value:用户信息
     */
    List<UserSimpleInfo> getUserInfoByNums(Collection<String> nums);

    /**
     * 根据部门ID查询用户ID
     *
     * @param nodeIds 组织架构ID
     * @return 用户ID
     */
    Set<Long> queryIdsByNodeIds(Collection<Long> nodeIds);

    /**
     * 获取用户角色对应的组织类型
     *
     * @param roleId 角色id
     * @return 组织类型 1：总部 2：分校
     */
    Integer getUserRoleOrgType(Long roleId);
}
