package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.resp.ChannelDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 渠道接口
 *
 * @author yanmaoyuan
 * @date 2021/9/14
 */
public interface ScrmChannelService {

    /**
     * 根据ID批量查询渠道
     *
     * @param ids 渠道ID
     * @return 渠道列表
     */
    List<ChannelDto> getByIds(Collection<Long> ids);

    /**
     * 根据ID批量查询渠道名称
     *
     * @param ids 渠道ID
     * @return key:渠道id, value:渠道名
     */
    Map<Long, String> getNameByIds(Collection<Long> ids);

    /**
     * 查询渠道num对应的id
     *
     * @param nums 渠道num
     * @return key:num, value:id
     */
    Map<String, Long> getIdByNums(Collection<String> nums);

    /**
     * 查询渠道id对应的num
     *
     * @param ids 渠道id
     * @return key:id, value:num
     */
    Map<Long, String> getNumByIds(Collection<Long> ids);
}