package com.kuaike.scrm.common.service.dto.resp;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@AllArgsConstructor
@NoArgsConstructor
@Data
public class NoticeItemDto implements Serializable {

    private static final long serialVersionUID = -773594642268793457L;

    private String num;
    /**
     * 提醒类型
     *
     * @link {com.kuaike.scrm.common.enums.NoticeType}
     */
    private Integer type;

    /**
     * 提醒消息内容
     */
    private String message;

    /**
     * 消息提醒时间
     */
    private Date noticeTime;

    /**
     * 消息创建时间
     */
    private Date createTime;

    /**
     * 是否已读
     */
    private Integer haveDeal;
}
