package com.kuaike.scrm.common.service;


import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.service.dto.AppCallRespDto;
import com.kuaike.scrm.common.service.dto.req.AppCalledReqDto;
import com.kuaike.scrm.common.service.dto.req.ScrmCallOutReq;
import com.kuaike.scrm.common.service.dto.req.voicematerial.*;
import com.kuaike.scrm.common.service.dto.resp.AppCalledRespDto;
import com.kuaike.scrm.common.service.dto.resp.CallRecordDto;
import com.kuaike.scrm.common.service.dto.resp.voicematerial.CreateVoiceCallResp;
import com.kuaike.scrm.common.service.dto.resp.voicematerial.VoiceMaterialDetailResp;
import com.kuaike.scrm.common.service.dto.resp.voicematerial.VoiceMaterialListResp;

import java.util.List;

/**
 * @author lanye
 */
public interface ScrmCallService {

    /**
     * 通话记录
     *
     * @param phones
     * @param pageDto
     * @return
     */
    AppCallRespDto recordList(List<String> phones, PageDto pageDto);

    /**
     * 通话记录
     *
     * @param phone
     * @param pageDto
     * @return
     */
    AppCallRespDto recordList(String phone, PageDto pageDto);

    /**
     * 根据批次号查询通话记录
     *
     * @param batchId
     * @return
     */
    AppCallRespDto record(String batchId);

    /**
     * 是否呼叫过
     *
     * @param reqDto
     * @return
     */
    List<AppCalledRespDto> called(AppCalledReqDto reqDto);

    /**
     * 通话记录
     *
     * @param nums
     * @return
     */
    List<CallRecordDto> recordList(List<String> nums);

    /**
     * 呼出
     *
     * @return
     */
    String callOut(ScrmCallOutReq params);

    /**
     * 查询外呼记录的语音通话记录
     *
     * @param bizId
     * @param voiceUrl
     * @return
     */
    String getFullVoiceUrl(Long bizId, String voiceUrl);

    /**
     * 查询商户的外呼配置
     *
     * @param bizId
     * @return
     */
    boolean isOpen(Long bizId);

    /**
     * 商户是否开通语音外呼
     *
     * @param bizId
     * @return
     */
    boolean isOpenVoice(Long bizId);

    /**
     * 新增语音素材
     *
     * @param req
     * @return
     */
    String addVoiceMaterial(AddVoiceMaterialReq req);

    /**
     * 语音素材详情
     *
     * @param req
     * @return
     */
    VoiceMaterialDetailResp voiceMaterialDetail(VoiceMaterialIdReq req);

    /**
     * 编辑语音素材
     *
     * @param req
     */
    void editVoiceMaterial(EditVoiceMaterialReq req);

    /**
     * 删除语音素材
     *
     * @param req
     */
    void delVoiceMaterial(VoiceMaterialIdReq req);

    /**
     * 语音素材列表
     *
     * @param req
     * @return
     */
    VoiceMaterialListResp voiceMaterialList(VoiceMaterialListReq req);

    /**
     * 新建语音外呼任务
     *
     * @param req
     * @return
     */
    CreateVoiceCallResp createVoiceCall(CreateVoiceCallReq req);

    /**
     * 通话统计
     *
     * @param reqDto
     * @return
     */
    List<AppCalledRespDto> callCount(AppCalledReqDto reqDto);
}
