package com.kuaike.scrm.common.service;

import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.dto.resp.Node;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author sunwen
 */
public interface NodeService {

    /**
     * 根据num查id
     *
     * @param bizId
     * @param num
     * @return
     */
    Long getIdByNum(Long bizId, String num);

    /**
     * 根据ID查询Num
     *
     * @param bizId
     * @param id
     * @return
     */
    String getNumById(Long bizId, Long id);

    /**
     * 根据num批量查询id
     *
     * @param bizId
     * @param nums
     * @return
     */
    Map<String, Long> getIdByNums(Long bizId, Collection<String> nums);

    /**
     * 根据ID批量查询num
     *
     * @param bizId
     * @param ids
     * @return
     */
    Map<Long, String> getNumByIds(Long bizId, Collection<Long> ids);

    /**
     * 根据ID批量查询部门名称
     *
     * @param bizId
     * @param ids
     * @return
     */
    Map<Long, String> getFullNameByIds(Long bizId, Collection<Long> ids);

    /**
     * 根据id批量查询部门名称，取当前名称
     */
    Map<Long, String> getNameByIds(Long bizId, Collection<Long> ids);

    Map<Long, Node> getNodeMap(Long bizId);

    Set<Long> getPosterityIds(Long nodeId, Long bizId);

    /**
     * 获取部门以及其下的所有子部门
     *
     * @param nodeIds 部门id集合
     * @param bizId   商户id
     * @return 部门及子部门集合
     */
    Set<Long> getPosterityIds(Collection<Long> nodeIds, Long bizId);

    void clearCache(Long bizId);

    Node getNode(Long nodeId, Long bizId);

    Long getRootNodeId(Long bizId);

    Node getRootNode(Long bizId);

    /**
     * 批量查询部门信息
     * @param nodeIds 部门ID
     * @param bizId 商户ID
     * @return key:部门id value:部门信息
     */
    Map<Long, Node> getNodeByIds(Collection<Long> nodeIds, Long bizId);

    /**
     * 根据部门id获取org_code
     **/
    Map<Long,String> getOrgCodeByIds(Long bizId,Collection<Long> ids);

    String getOrgNameById(Long bizId, Long orgId);

    /**
     * 获取当前用户管辖权限下的分校
     *
     * @return 分校id和名称对象集合
     */
    List<IdAndNameDto> getBranchSchools(Set<Long> manageNodeIds);
}
