/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.accesstoken.entity.CorpCustomizedToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpCustomizedTokenMapper;
import com.kuaike.scrm.dal.agent.entity.AgentToken;
import com.kuaike.scrm.dal.agent.mapper.AgentTokenMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkSyncTask;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkSyncTaskMapper;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.dto.SyncTaskDto;
import com.kuaike.scrm.synctask.service.dto.req.SyncTypeReq;
import com.kuaike.scrm.synctask.service.enums.SyncTaskStatus;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class SyncTaskServiceImpl
implements SyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(SyncTaskServiceImpl.class);
    @Autowired
    private AgentTokenMapper agentTokenMapper;
    @Autowired
    private WeworkSyncTaskMapper weworkSyncTaskMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private CorpCustomizedTokenMapper corpCustomizedTokenMapper;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Value(value="${kafka.topic.qyapi_syncdata}")
    private String topic;
    @Value(value="${qyapi.customized.id}")
    private String customizedId;
    @Value(value="${scrm.synctask.expireDays:30}")
    private Integer expireDays;
    private static final int MAX_ERROR_MSG_LEN = 120;
    private static final int TASK_TIMEOUT = 600;
    private static final Long GROUP_MSG_TASK_TIMEOUT = 86400000L;

    @Override
    public SyncTaskStatus getTaskStatus(Long id) {
        WeworkSyncTask weworkSyncTask = (WeworkSyncTask)this.weworkSyncTaskMapper.selectByPrimaryKey((Object)id);
        if (weworkSyncTask == null) {
            log.warn("\u4f01\u5fae\u540c\u6b65\u4efb\u52a1\u4e0d\u5b58\u5728, id:{}", (Object)id);
            return null;
        }
        return SyncTaskStatus.get(weworkSyncTask.getStatus());
    }

    @Override
    public void startAll() {
        log.info("start sync task");
        this.deleteExpireTask(this.expireDays);
        List corpList = this.weworkCorpMapper.selectAllAuthed();
        if (CollectionUtils.isEmpty((Collection)corpList)) {
            log.info("no authed corp found");
            return;
        }
        List corpIds = corpList.stream().map(WeworkCorp::getCorpId).collect(Collectors.toList());
        List corpCustomizedTokenList = this.corpCustomizedTokenMapper.getByCorpIds(corpIds, this.customizedId);
        if (CollectionUtils.isEmpty((Collection)corpCustomizedTokenList)) {
            log.info("no authed customized app");
            return;
        }
        Map corpCustomizedTokenMap = corpCustomizedTokenList.stream().collect(Collectors.toMap(CorpCustomizedToken::getCorpId, Function.identity()));
        ArrayList types = Lists.newArrayList((Object[])new SyncTaskType[]{SyncTaskType.CONTACT, SyncTaskType.EXTERNAL_CONTACT, SyncTaskType.EXTERNAL_CHAT, SyncTaskType.EXTERNAL_TAG, SyncTaskType.CUSTOMIZED_APP, SyncTaskType.SUITE, SyncTaskType.VIP_WEWORK_CONTACT, SyncTaskType.VIP_WEWORK_CHAT_ROOM});
        for (WeworkCorp corp : corpList) {
            Long bizId = corp.getBizId();
            String corpId = corp.getCorpId();
            CorpCustomizedToken customizedToken = (CorpCustomizedToken)corpCustomizedTokenMap.get(corpId);
            if (customizedToken == null || customizedToken.getIsAuth() == 0 || customizedToken.getDevStatus().intValue() != CustomizedAppDevStatus.DONE.getValue()) {
                log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, \u4e0d\u6267\u884c\u6570\u636e\u540c\u6b65\uff0ccorpId={}", (Object)corpId);
                continue;
            }
            for (SyncTaskType type : types) {
                this.start(bizId, corpId, type, -1L);
            }
            AgentToken token = this.agentTokenMapper.queryByBizId(bizId);
            if (token == null) continue;
            this.start(bizId, corpId, SyncTaskType.AGENT_ID_CONVERT, -1L);
        }
    }

    private void deleteExpireTask(int expireDays) {
        if (expireDays <= 0) {
            expireDays = 1;
        }
        log.info("\u5220\u9664 {} \u5929\u524d\u7684\u540c\u6b65\u4efb\u52a1", (Object)expireDays);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -expireDays);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        this.weworkSyncTaskMapper.deleteExpiredTask(date);
    }

    @Override
    public Long start(Integer type) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        SyncTaskType taskType = SyncTaskType.get(type);
        Preconditions.checkArgument((taskType != null ? 1 : 0) != 0, (Object)"\u540c\u6b65\u4efb\u52a1\u7c7b\u578b\u4e0d\u6b63\u786e");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        return this.start(bizId, corpId, taskType, operatorId);
    }

    @Override
    public Long startWithOutMq(Long bizId, String corpId, SyncTaskType type, Long createBy, SyncTaskStatus taskStatus) {
        if (Objects.isNull((Object)taskStatus)) {
            taskStatus = SyncTaskStatus.START;
        }
        WeworkSyncTask weworkSyncTask = new WeworkSyncTask();
        weworkSyncTask.setBizId(bizId);
        weworkSyncTask.setCorpId(corpId);
        weworkSyncTask.setType(Integer.valueOf(type.getValue()));
        weworkSyncTask.setStatus(Integer.valueOf(taskStatus.getValue()));
        weworkSyncTask.setCreateBy(createBy);
        weworkSyncTask.setCreateTime(new Date());
        weworkSyncTask.setUpdateTime(new Date());
        this.weworkSyncTaskMapper.insertSelective((Object)weworkSyncTask);
        Long taskId = weworkSyncTask.getId();
        log.info("start sync task, taskId:{}, corpId:{}, type:{}", new Object[]{taskId, corpId, type});
        return taskId;
    }

    @Override
    public Long start(Long bizId, String corpId, SyncTaskType type, Long createBy) {
        Date deadline = new Date(System.currentTimeMillis() - 600000L);
        Long taskId = this.weworkSyncTaskMapper.getRunningTaskId(corpId, type.getValue(), deadline);
        if (taskId != null) {
            log.info("task has already been started, taskId:{}, corpId:{}, type:{}", new Object[]{taskId, corpId, type});
            return taskId;
        }
        taskId = this.startWithOutMq(bizId, corpId, type, createBy, SyncTaskStatus.START);
        SyncTaskDto dto = new SyncTaskDto();
        dto.setCorpId(corpId);
        dto.setType(type.name());
        dto.setTaskId(taskId);
        String json = JacksonUtil.obj2Str((Object)dto);
        try {
            this.kafkaTemplate.send(this.topic, (Object)corpId, (Object)json);
            log.info("send kafka: {}", (Object)json);
        }
        catch (Exception e) {
            log.error("send kafka failed: {}\n", (Object)json, (Object)e);
        }
        return taskId;
    }

    @Override
    public void running(Long id) {
        WeworkSyncTask weworkSyncTask = new WeworkSyncTask();
        weworkSyncTask.setId(id);
        weworkSyncTask.setStatus(Integer.valueOf(SyncTaskStatus.RUNNING.getValue()));
        weworkSyncTask.setUpdateTime(new Date());
        this.weworkSyncTaskMapper.updateByPrimaryKeySelective((Object)weworkSyncTask);
    }

    @Override
    public void success(Long id, int costTime) {
        WeworkSyncTask weworkSyncTask = new WeworkSyncTask();
        weworkSyncTask.setId(id);
        weworkSyncTask.setStatus(Integer.valueOf(SyncTaskStatus.SUCCESS.getValue()));
        weworkSyncTask.setCostTime(Integer.valueOf(costTime));
        weworkSyncTask.setUpdateTime(new Date());
        this.weworkSyncTaskMapper.updateByPrimaryKeySelective((Object)weworkSyncTask);
    }

    @Override
    public void failed(Long id, String errorMsg) {
        String msg = null;
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            msg = StringUtils.abbreviate((String)errorMsg, (int)120);
        }
        WeworkSyncTask weworkSyncTask = new WeworkSyncTask();
        weworkSyncTask.setId(id);
        weworkSyncTask.setStatus(Integer.valueOf(SyncTaskStatus.FAILED.getValue()));
        weworkSyncTask.setErrorMsg(msg);
        weworkSyncTask.setUpdateTime(new Date());
        this.weworkSyncTaskMapper.updateByPrimaryKeySelective((Object)weworkSyncTask);
    }

    @Override
    public Date lastSyncTime(SyncTypeReq params) {
        if (params == null || params.getType() == null) {
            return null;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        WeworkSyncTask syncTask = this.weworkSyncTaskMapper.queryLastSyncInfo(userInfo.getCorpId(), params.getType().intValue());
        if (syncTask == null) {
            return null;
        }
        return syncTask.getUpdateTime();
    }

    @Override
    public Long getLastRunningTask(String corpId, SyncTaskType syncTaskType) {
        if (Objects.isNull(corpId) || Objects.isNull((Object)syncTaskType)) {
            return null;
        }
        Date deadline = new Date(System.currentTimeMillis() - GROUP_MSG_TASK_TIMEOUT);
        return this.weworkSyncTaskMapper.getRunningTaskId(corpId, syncTaskType.getValue(), deadline);
    }
}

