/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.ModBaseInfoDto;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.crm.common.service.dto.req.CrmModMobileReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CommonKafkaMsg;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.synctask.service.RemarkMobileSyncService;
import com.kuaike.scrm.synctask.service.dto.RemarkMobileSyncDto;
import com.kuaike.scrm.wework.contact.service.ContactCenterService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class RemarkMobileSyncServiceImpl
implements RemarkMobileSyncService {
    private static final Logger log = LoggerFactory.getLogger(RemarkMobileSyncServiceImpl.class);
    @Value(value="${kafka.topic.scrm_common_msg}")
    private String topic;
    @Autowired
    private IdGen idGen;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private ContactCenterService contactCenterService;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;

    @Override
    public void doSync(RemarkMobileSyncDto params) {
        log.info("\u540c\u6b65\u4f01\u5fae\u5907\u6ce8\u624b\u673a\u53f7\u5230CRM\u4e0e\u5ba2\u6237\u4e2d\u5fc3, params:{}", (Object)params);
        if (CollectionUtils.isEmpty(params.getRemarkMobile()) || StringUtils.isBlank((CharSequence)params.getRemarkMobile().get(0))) {
            log.info("\u573a\u666f3: \u6ca1\u6709\u5907\u6ce8\u624b\u673a\u53f7\uff0c\u65e0\u9700\u64cd\u4f5c\u3002");
            return;
        }
        String mobile1 = params.getRemarkMobile().get(0).trim();
        Long bizId = params.getBizId();
        String customerNum = params.getCustomerNum();
        BizSimpleDto biz = this.scrmBizService.getById(params.getBizId());
        boolean isOpenCrm = Objects.equals(biz.getIsOpenCrm(), NumberUtils.INTEGER_ONE);
        CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum);
        log.info("query customer detail mobile1:{}, mobile2:{}", (Object)detailResp.getMobile1(), (Object)detailResp.getMobile2());
        if (StringUtils.isNotBlank((CharSequence)detailResp.getMobile1())) {
            this.caseOneEditMobile(params, detailResp, mobile1, isOpenCrm);
        } else {
            this.caseTwoAddMobile(params, detailResp, mobile1, isOpenCrm);
        }
    }

    private void caseOneEditMobile(RemarkMobileSyncDto params, CustomerDetailResp detailResp, String mobile, boolean isOpenCrm) {
        log.info("\u573a\u666f1: \u4f01\u4e1a\u5fae\u4fe1\u5df2\u7ecf\u7ed1\u5b9a\u624b\u673a\u53f7A\uff0c\u5c1d\u8bd5\u7ed1\u5b9a\u5907\u6ce8\u624b\u673a\u53f7B\u3002params:{}, detailResp:{}, mobile:{}, isOpenCrm:{}", new Object[]{params, detailResp, mobile, isOpenCrm});
        Long bizId = params.getBizId();
        String corpId = params.getCorpId();
        String contactId = params.getContactId();
        String customerNum = params.getCustomerNum();
        Long userId = params.getAllocUserId();
        String name = params.getName();
        List<String> tagIds = params.getTagIds();
        if (this.checkMobileBindCustomer(bizId, mobile, contactId)) {
            log.info("\u624b\u673a\u53f7[{}]\u5df2\u7ecf\u7ed1\u5b9a\u5fae\u4fe1\uff0c\u5ffd\u7565\u8be5\u5907\u6ce8\u624b\u673a\u53f7", (Object)mobile);
            return;
        }
        if (mobile.equals(detailResp.getMobile1()) || mobile.equals(detailResp.getMobile2())) {
            log.warn("\u624b\u673a\u53f7\u53ef\u80fd\u5e76\u6ca1\u6709\u4fee\u6539, mobile:{}, mobile1:{}, mobile2:{}", new Object[]{mobile, detailResp.getMobile1(), detailResp.getMobile2()});
        }
        boolean flag = true;
        if (isOpenCrm) {
            try {
                flag = this.makeCrmLeads(corpId, bizId, mobile, userId, name, tagIds, contactId, detailResp);
            }
            catch (Exception e) {
                log.error("modMobile error: ", (Throwable)e);
            }
        }
        try {
            if (flag) {
                this.modMobileToCustomer(bizId, customerNum, mobile);
                this.sendCallbackToKafka(params, detailResp, mobile);
            } else {
                log.info("\u7531\u4e8eCRM\u7ebf\u7d22\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u6539\u52a8\u5ba2\u6237\u4e2d\u5fc3\u5f52\u5c5e\u3002bizId:{}, mobile:{}, contactId:{}", new Object[]{bizId, mobile, contactId});
            }
        }
        catch (Exception e) {
            log.error("modMobile error: ", (Throwable)e);
        }
    }

    private void caseTwoAddMobile(RemarkMobileSyncDto params, CustomerDetailResp detailResp, String mobile, boolean isOpenCrm) {
        log.info("\u573a\u666f2: \u4f01\u4e1a\u5fae\u4fe1\u539f\u6765\u6ca1\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u5c1d\u8bd5\u7ed1\u5b9a\u5907\u6ce8\u624b\u673a\u53f7\u3002params:{}, detailResp:{}, mobile:{}, isOpenCrm:{}", new Object[]{params, detailResp, mobile, isOpenCrm});
        Long bizId = params.getBizId();
        String corpId = params.getCorpId();
        String contactId = params.getContactId();
        String customerNum = params.getCustomerNum();
        Long userId = params.getAllocUserId();
        String name = params.getName();
        List<String> tagIds = params.getTagIds();
        if (this.checkMobileBindCustomer(bizId, mobile, contactId)) {
            log.info("\u624b\u673a\u53f7[{}]\u5df2\u7ecf\u7ed1\u5b9a\u5fae\u4fe1\uff0c\u5ffd\u7565\u8be5\u5907\u6ce8\u624b\u673a\u53f7", (Object)mobile);
            return;
        }
        try {
            if (isOpenCrm) {
                CrmLeadsInfoResp leads = this.getCrmLeadsInfo(bizId, corpId, mobile);
                if (leads != null) {
                    log.info("\u7ebf\u7d22\u5df2\u5b58\u5728\uff0c\u4ecd\u7136\u5c1d\u8bd5\u63a8\u9001\u7ebf\u7d22\u5230CRM\u89e6\u53d1\u5185\u7f6e\u5206\u914d\u903b\u8f91\u3002bizId:{}, mobile:{}, leadsId:{}", new Object[]{bizId, mobile, leads.getId()});
                } else {
                    log.info("\u7ebf\u7d22\u4e0d\u5b58\u5728\uff0c\u5373\u5c06\u4ea7\u751f\u65b0\u7ebf\u7d22\u3002bizId:{}, mobile:{}", (Object)bizId, (Object)mobile);
                }
                this.addCrmLeads(bizId, corpId, mobile, name, tagIds, userId, contactId);
            }
            this.modMobileToCustomer(bizId, customerNum, mobile);
            this.sendCallbackToKafka(params, detailResp, mobile);
        }
        catch (Exception e) {
            log.error("modMobile error: ", (Throwable)e);
        }
    }

    private void modMobileToCustomer(Long bizId, String customerNum, String mobile) {
        log.info("\u4fee\u6539\u5ba2\u6237\u4e2d\u5fc3\u624b\u673a\u53f7\u7ed1\u5b9a\u5173\u7cfb, bizId:{}, customerNum: {}, mobile: {}", new Object[]{bizId, customerNum, mobile});
        ModMobileReq req = new ModMobileReq();
        req.setBizId(bizId);
        req.setMobile1(mobile);
        req.setCustomerNum(customerNum);
        req.setModuleType(ModuleType.REMARK_MOBILE.getCode());
        req.setSource("scrm");
        this.ccCustomerInfoService.modCustomerMobiles(req);
    }

    private boolean checkMobileBindCustomer(Long bizId, String mobile, String expectedContactId) {
        log.info("\u68c0\u6d4b\u624b\u673a\u53f7\u662f\u5426\u5df2\u7ed1\u5b9a\u5fae\u4fe1, bizId:{}, mobile:{}", (Object)bizId, (Object)mobile);
        boolean ret = false;
        String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, mobile);
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            log.info("mobile customerNum is empty");
            return false;
        }
        String contactId = this.ccCustomerNumService.getWeworkContactId(bizId, customerNum);
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            ret = !Objects.equals(contactId, expectedContactId);
            log.info("\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a{}\u5fae\u4fe1, bizId:{}, mobile:{}, contactId:{}", new Object[]{ret ? "\u5176\u5b83" : "\u5f53\u524d", bizId, mobile, contactId});
        } else {
            log.info("\u624b\u673a\u53f7\u672a\u7ed1\u5b9a\u5fae\u4fe1, bizId:{}, mobile:{}", (Object)bizId, (Object)mobile);
        }
        return ret;
    }

    public boolean makeCrmLeads(String corpId, Long bizId, String mobile, Long userId, String name, List<String> tagIds, String contactId, CustomerDetailResp detailResp) {
        log.info("make crm leads, corpId:{}, mobile:{}", (Object)corpId, (Object)mobile);
        CrmLeadsInfoResp existsLeads = this.contactCenterService.checkAndGetCrmLeads(bizId, corpId, detailResp, mobile);
        CrmLeadsInfoResp newLeads = this.contactCenterService.getCrmLeadsInfo(bizId, corpId, mobile);
        if (newLeads != null) {
            log.info("\u624b\u673a\u53f7\u7ebf\u7d22\u5df2\u5b58\u5728\uff0c\u4e0d\u6539\u53d8\u4f01\u5fae\u5ba2\u6237\u4e0e\u624b\u673a\u53f7\u7684\u7ed1\u5b9a\u5173\u7cfb\u3002bizId:{}, mobile:{}", (Object)bizId, (Object)mobile);
            if (existsLeads != null && !Objects.equals(existsLeads.getId(), newLeads.getId())) {
                if (Objects.equals(existsLeads.getMobile(), newLeads.getMobile())) {
                    log.warn("\u53d1\u73b0\u4e24\u6761\u4e0d\u540c\u7684\u7ebf\u7d22\uff0c\u624b\u673a\u53f7\u76f8\u540c\uff01 bizId:{}, mobile:{}, leadsId:{}, leadsId:{}", new Object[]{bizId, mobile, existsLeads.getId(), newLeads.getId()});
                }
                if (StringUtils.isBlank((CharSequence)existsLeads.getMobile1())) {
                    log.info("\u628a\u65b0\u5907\u6ce8\u624b\u673a\u53f7\uff0c\u586b\u5145\u5230\u7ebf\u7d22\u7684mobile1\u5b57\u6bb5\u4e0a\u3002");
                    this.modCrmLeadsMobile(corpId, existsLeads.getNum(), existsLeads.getMobile(), mobile);
                } else {
                    log.warn("\u7ebf\u7d22\u7684mobile1\u5b57\u6bb5\u5df2\u5b58\u5728\uff0c\u5ffd\u7565\u65b0\u5907\u6ce8\u7684\u624b\u673a\u53f7\u3002");
                }
            }
            return false;
        }
        if (existsLeads != null) {
            log.info("\u4fee\u6539\u7ebf\u7d22\u624b\u673a\u53f7, bizId:{}, from:{}, to:{}, leadsId:{}", new Object[]{bizId, existsLeads.getMobile(), mobile, existsLeads.getId()});
            String mobile1 = null;
            if (StringUtils.isNotBlank((CharSequence)existsLeads.getMobile1()) && !Objects.equals(mobile, existsLeads.getMobile1())) {
                mobile1 = existsLeads.getMobile1();
            }
            this.modCrmLeadsMobile(corpId, existsLeads.getNum(), mobile, mobile1);
        } else {
            log.info("\u7ebf\u7d22\u4e0d\u5b58\u5728\uff0c\u5373\u5c06\u751f\u4ea7\u65b0\u7ebf\u7d22\u3002bizId:{}, mobile:{}", (Object)bizId, (Object)mobile);
        }
        this.addCrmLeads(bizId, corpId, mobile, name, tagIds, userId, contactId);
        return true;
    }

    private void addCrmLeads(Long bizId, String corpId, String mobile, String name, List<String> tagIds, Long userId, String contactId) {
        log.info("add crm leads, corpId:{}, mobile:{}, name: {}, tagIds: {}", new Object[]{corpId, mobile, name, tagIds});
        CustomerDetailResp customerDetail = this.ccCustomerNumService.getCustomerDetailByType(bizId, contactId);
        Long channelId = null;
        if (customerDetail != null && customerDetail.getChannelId() != null) {
            channelId = this.channelMapper.getIdByNum(bizId, customerDetail.getChannelId());
        }
        if (channelId == null) {
            channelId = this.channelMapper.querySysChannelId(SysChannelEnum.QY_WEIXIN.getCode());
        }
        CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
        crmLeadsReq.setCorpId(corpId);
        crmLeadsReq.setMobile(mobile);
        crmLeadsReq.setName(name);
        crmLeadsReq.setTagIds(tagIds);
        crmLeadsReq.setCreatorId(Long.valueOf(-1L));
        crmLeadsReq.setSourceType(Integer.valueOf(SourceType.SCRM_SYNC.getValue()));
        crmLeadsReq.setChannelId(channelId);
        crmLeadsReq.setAllocUserId(userId);
        try {
            this.crmLeadsService.addLeads(crmLeadsReq);
        }
        catch (Exception e) {
            log.error("addCrmLeads,crmLeadsReq:{}\u53d1\u751f\u5f02\u5e38", (Object)crmLeadsReq, (Object)e);
        }
    }

    public CrmLeadsInfoResp getCrmLeadsInfo(Long bizId, String corpId, String mobile) {
        log.info("get crm leads, bizId:{}, mobile:{}", (Object)bizId, (Object)mobile);
        CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
        crmLeadsInfoReq.setBizId(bizId);
        crmLeadsInfoReq.setCorpId(corpId);
        crmLeadsInfoReq.setMobile(mobile);
        return this.crmLeadsService.getLeads(crmLeadsInfoReq);
    }

    private void modCrmLeadsMobile(String corpId, String leadsNum, String mobile, String mobile1) {
        log.info("mod crm leads mobile, corpId:{}, leadsNum:{}, mobile:{}, mobile1:{}", new Object[]{corpId, leadsNum, mobile, mobile1});
        CrmModMobileReq req = new CrmModMobileReq();
        req.setCorpId(corpId);
        req.setLeadsNum(leadsNum);
        req.setMobile(mobile);
        req.setMobile1(mobile1);
        try {
            this.crmLeadsService.modMobiles(req);
        }
        catch (Exception e) {
            log.error("modCrmLeadsMobile,req:{}\u53d1\u751f\u5f02\u5e38:", (Object)req, (Object)e);
        }
    }

    private void sendCallbackToKafka(RemarkMobileSyncDto params, CustomerDetailResp detailResp, String mobile) {
        log.info("base_info_edit_callback, params:{}, detailResp:{}, mobile:{}", new Object[]{params, detailResp, mobile});
        CommonKafkaMsg msg = new CommonKafkaMsg();
        msg.setSys("scrm");
        msg.setType("base_info_edit_callback");
        msg.setBizId(params.getBizId());
        msg.setCorpId(params.getCorpId());
        msg.setKey(this.idGen.getNum());
        Map channelMap = this.channelMapper.selectNameByNums(params.getBizId(), (Collection)Lists.newArrayList((Object[])new String[]{detailResp.getChannelId()}));
        ModBaseInfoDto modBaseInfoDto = ModBaseInfoDto.builder().contactId(detailResp.getContactId()).unionId(detailResp.getUnionId()).oldMobile1(detailResp.getMobile1()).oldMobile2(detailResp.getMobile2()).mobile1(mobile).name(detailResp.getName()).remarkName(params.getRemark()).gender(detailResp.getGender()).channel(channelMap.getOrDefault(detailResp.getChannelId(), "")).updateTime(new Date()).build();
        msg.setData(JacksonUtil.obj2Str((Object)modBaseInfoDto));
        this.kafkaTemplate.send(this.topic, (Object)JacksonUtil.obj2Str((Object)msg));
    }
}

