/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.scrm.vip.service.IdTranslateService;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.VipWeworkChatRoomSyncService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VipWeworkChatRoomSyncServiceImpl
implements VipWeworkChatRoomSyncService {
    private static final Logger log = LoggerFactory.getLogger(VipWeworkChatRoomSyncServiceImpl.class);
    private static final int PAGE_SIZE = 1000;
    private final ExecutorService executor = new ThreadPoolExecutor(0, 8, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("sync-vip-wework-chat-room-digit-id-%d").build());
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private IdTranslateService idTranslateService;

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Integer devStatus = this.customizedTokenService.getAuthStatus(bizId);
        if (devStatus == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        if (devStatus.intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210");
        }
        return this.syncTaskService.start(bizId, corpId, SyncTaskType.VIP_WEWORK_CHAT_ROOM, operatorId);
    }

    @Override
    public void fetch(String corpId) {
        log.info("sync vip wework chat room digit id, corpId:{}", (Object)corpId);
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        List weworkUserIds = this.vipWeworkAuthorizeAccountMapper.queryAvailableUserIds(corpId);
        log.info("user ids:{}", (Object)weworkUserIds);
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            log.warn("userIds is empty, corpId:{}", (Object)corpId);
            return;
        }
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (accessToken == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        this.startMatchingDigitId(corpId, weworkUserIds);
    }

    private void startMatchingDigitId(String corpId, List<String> weworkUserIds) {
        int count = this.weworkChatRoomMapper.selectNoDigitIdCount(corpId, weworkUserIds);
        if (count == 0) {
            log.info("\u6ca1\u6709\u9700\u8981\u6253\u901a\u7684\u5ba2\u6237\u7fa4\u6570\u636e, corpId={}, weworkUserIds={}", (Object)corpId, weworkUserIds);
            return;
        }
        PageDto pageDto = new PageDto();
        pageDto.setCount(Integer.valueOf(count));
        pageDto.setPageSize(Integer.valueOf(1000));
        pageDto.setPageNum(Integer.valueOf(1));
        int totalPageNum = pageDto.getTotalPageNum();
        for (int page = 1; page <= totalPageNum; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            List list = this.weworkChatRoomMapper.selectNoDigitIdList(corpId, weworkUserIds, pageDto);
            log.info("match page={}/{}, size={}", new Object[]{page, totalPageNum, list.size()});
            for (WeworkChatRoom it : list) {
                this.executor.submit(() -> {
                    try {
                        this.idTranslateService.matchChatRoomDigitId(it);
                    }
                    catch (Exception e) {
                        log.error("\u5339\u914d\u589e\u5f3a\u7248\u7fa4ID\u5931\u8d25, corpId={}, weworkRoomId={}", new Object[]{it.getCorpId(), it.getWeworkRoomId(), e});
                    }
                });
            }
        }
    }
}

