/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.wework.sdk.api.AgentApi;
import cn.kinyun.wework.sdk.api.DepartmentApi;
import cn.kinyun.wework.sdk.api.UserApi;
import cn.kinyun.wework.sdk.entity.agent.Agent;
import cn.kinyun.wework.sdk.entity.agent.AllowPartys;
import cn.kinyun.wework.sdk.entity.agent.AllowUserInfos;
import cn.kinyun.wework.sdk.entity.contact.department.Department;
import cn.kinyun.wework.sdk.entity.contact.user.UserInfo;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.WeworkCorpSyncStatus;
import com.kuaike.scrm.common.enums.WeworkUserSyncStatus;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartmentUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.synctask.service.SuiteUserIdSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.system.service.UserService;
import com.kuaike.scrm.token.service.CorpTokenService;
import com.kuaike.scrm.token.service.SuiteTokenService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Deprecated
public class SuiteUserIdSyncServiceImpl
implements SuiteUserIdSyncService {
    private static final Logger log = LoggerFactory.getLogger(SuiteUserIdSyncServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private AgentApi agentApi;
    @Autowired
    private DepartmentApi departmentApi;
    @Autowired
    private SuiteTokenService suiteTokenService;
    @Autowired
    private CorpTokenService corpTokenService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkDepartmentMapper weworkDepartmentMapper;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String prefix;
    ExecutorService executor = new ThreadPoolExecutor(5, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("match-userid-%d").setUncaughtExceptionHandler((thread, ex) -> log.error("\u540c\u6b65\u8d26\u53f7\u5931\u8d25", ex)).build());

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Long taskId = this.syncTaskService.start(bizId, corpId, SyncTaskType.USER_ID, operatorId);
        return taskId;
    }

    @Override
    public void fetch(String corpId) {
        log.info("sync userIds, corpId={}", (Object)corpId);
        if (this.isMatching(corpId)) {
            log.info("skip sync, now is synchronizing, corpId={}", (Object)corpId);
            return;
        }
        ArrayList departIds = Lists.newArrayList();
        ArrayList userIds = Lists.newArrayList();
        this.fetchSuiteDepartIds(corpId, departIds, userIds);
        this.tryMatchUserIds(corpId, departIds, userIds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void tryMatchUserIds(String corpId, List<Integer> deptIds, List<String> userIds) {
        log.info("try match userids, corpId={}, deptIds={}, userIds={}", new Object[]{corpId, deptIds, userIds});
        if (CollectionUtils.isEmpty(deptIds)) {
            log.warn("\u7b2c\u4e09\u65b9\u5e94\u7528\u81f3\u5c11\u8981\u9009\u62e9\u4e00\u4e2a\u90e8\u95e8, corpId={}", (Object)corpId);
            return;
        }
        Long timestamp = this.lock(corpId, null);
        Integer dummyDepartId = this.createDummyDepartment(corpId, deptIds);
        if (dummyDepartId == null) {
            log.warn("\u521b\u5efa\u90e8\u95e8\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u901a\u8baf\u5f55\u52a9\u624b\u6ca1\u6709API\u7f16\u8f91\u6743\u9650. corpId={}", (Object)corpId);
            this.unlock(corpId);
            return;
        }
        HashSet uids = Collections.emptySet();
        if (CollectionUtils.isNotEmpty(userIds)) {
            uids = Sets.newHashSet(userIds);
        }
        try {
            Integer[] departIds = new Integer[]{};
            try {
                List<UserInfo> userList = this.fetchUserList(corpId);
                timestamp = this.lock(corpId, timestamp);
                if (CollectionUtils.isNotEmpty(userList)) {
                    int departCount = this.calculateDepartmentCount(userList.size());
                    departIds = new Integer[departCount];
                    this.createSyncDepartments(corpId, dummyDepartId, departIds);
                    timestamp = this.lock(corpId, timestamp);
                    this.matching(corpId, userList, departIds, uids, timestamp);
                    Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
                    this.businessCustomerMapper.updateSyncStatus(bizId, Integer.valueOf(WeworkCorpSyncStatus.MATCH_USER_ID.getValue()));
                } else {
                    log.info("\u6ca1\u6709\u9700\u8981\u8fdb\u884c\u8d26\u53f7\u540c\u6b65\u7684\u4f01\u4e1a\u6210\u5458, corpId:{}", (Object)corpId);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.deleteSyncDepartments(corpId, departIds);
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    log.info("\u5220\u9664dummy\u90e8\u95e8, corpId={}, dummy={}", (Object)corpId, (Object)dummyDepartId);
                    String accessToken = this.corpTokenService.getContactAccessToken(corpId);
                    this.departmentApi.delete(accessToken, dummyDepartId);
                }
                catch (Exception e2) {
                    log.error("\u5220\u9664dummy\u90e8\u95e8\u5931\u8d25. corpId={}, dummy={}", new Object[]{corpId, dummyDepartId, e2});
                }
                this.unlock(corpId);
                throw throwable;
            }
        }
        try {
            log.info("\u5220\u9664dummy\u90e8\u95e8, corpId={}, dummy={}", (Object)corpId, (Object)dummyDepartId);
            String accessToken = this.corpTokenService.getContactAccessToken(corpId);
            this.departmentApi.delete(accessToken, dummyDepartId);
        }
        catch (Exception e) {
            log.error("\u5220\u9664dummy\u90e8\u95e8\u5931\u8d25. corpId={}, dummy={}", new Object[]{corpId, dummyDepartId, e});
        }
        this.unlock(corpId);
    }

    private List<UserInfo> fetchUserList(String corpId) {
        String accessToken = this.corpTokenService.getContactAccessToken(corpId);
        List list = this.userApi.list(accessToken, Integer.valueOf(1), Integer.valueOf(1));
        log.info("list:{}", (Object)list);
        List weworkUserIds = this.weworkUserMapper.getSynchronizedWeworkUserIds(corpId);
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            return list;
        }
        HashSet ids = Sets.newHashSet();
        ids.addAll(weworkUserIds);
        return list.stream().filter(u -> !ids.contains(u.getUserId())).collect(Collectors.toList());
    }

    @Override
    public void fetchSuiteDepartIds(String corpId, List<Integer> saveDepartIds, List<String> saveUserIds) {
        List userList;
        Agent agent;
        log.info("get suite depart ids, corpId:{}", (Object)corpId);
        String accessToken = this.suiteTokenService.getSuiteAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u672a\u6388\u6743\u7b2c\u4e09\u65b9\u5e94\u7528, corpId:{}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u6388\u6743\u7b2c\u4e09\u65b9\u5e94\u7528");
        }
        Integer agentId = this.suiteTokenService.getSuiteAgentId(corpId);
        if (agentId == null) {
            log.warn("\u672a\u6388\u6743\u7b2c\u4e09\u65b9\u5e94\u7528, corpId:{}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u6388\u6743\u7b2c\u4e09\u65b9\u5e94\u7528");
        }
        try {
            agent = this.agentApi.getAgent(accessToken, agentId);
            log.info("Fetch suite:{}", (Object)agent);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", (Object)e.getMessage(), (Object)corpId);
            throw e;
        }
        catch (Exception e) {
            log.error("Fetch suite failed.", (Throwable)e);
            throw e;
        }
        List<String> userIds = Collections.emptyList();
        AllowUserInfos allowUserInfos = agent.getAllowUserInfos();
        if (allowUserInfos != null && CollectionUtils.isNotEmpty((Collection)(userList = allowUserInfos.getUserList()))) {
            userIds = userList.stream().map(it -> it.getUserId()).collect(Collectors.toList());
        }
        List deptIds = Collections.emptyList();
        AllowPartys allowPartys = agent.getAllowPartys();
        if (allowPartys != null && CollectionUtils.isNotEmpty((Collection)allowPartys.getPartyIdList())) {
            deptIds = allowPartys.getPartyIdList();
        }
        saveDepartIds.addAll(deptIds);
        ArrayList fetchUserList = Lists.newArrayList();
        HashSet fetchUserIds = Sets.newHashSet();
        for (String userId : userIds) {
            if (fetchUserIds.contains(userId)) continue;
            fetchUserIds.add(userId);
            fetchUserList.add(userId);
        }
        for (Integer deptId : deptIds) {
            List<UserInfo> list;
            try {
                list = this.userApi.list(accessToken, deptId, Integer.valueOf(1));
                if (list == null) {
                    list = Collections.emptyList();
                }
                log.info("fetch user list, deptId:{}, count:{}", (Object)deptId, (Object)list.size());
            }
            catch (WeworkException e) {
                log.error("{}, deptId:{}", (Object)e.getMessage(), (Object)deptId);
                throw e;
            }
            catch (Exception e) {
                log.error("fetch user list failed, deptId:{}", (Object)deptId, (Object)e);
                throw e;
            }
            for (UserInfo u : list) {
                if (fetchUserIds.contains(u.getUserId())) continue;
                fetchUserIds.add(u.getUserId());
                fetchUserList.add(u.getUserId());
            }
        }
        fetchUserList.sort(String::compareTo);
        saveUserIds.addAll(fetchUserList);
    }

    private void matching(String corpId, List<UserInfo> list, Integer[] departIds, Set<String> userIds, Long timestamp) {
        List pages = Lists.partition(list, (int)departIds.length);
        ArrayList tasks = Lists.newArrayListWithCapacity((int)departIds.length);
        HashSet excludeDepartIds = Sets.newHashSet();
        for (Integer deptId : departIds) {
            excludeDepartIds.add(deptId);
        }
        for (List page : pages) {
            int size = page.size();
            String accessToken = this.corpTokenService.getContactAccessToken(corpId);
            for (int i = 0; i < size; ++i) {
                UserInfo u = (UserInfo)page.get(i);
                Integer departId = departIds[i];
                tasks.add(() -> {
                    ArrayList newDepartIds = Lists.newArrayList((Iterable)u.getDepartment());
                    newDepartIds.add(departId);
                    this.userApi.updateDepartment(accessToken, u.getUserId(), (List)newDepartIds);
                    return null;
                });
            }
            try {
                this.executor.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            tasks.clear();
            timestamp = this.lock(corpId, timestamp);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            String suiteAccessToken = this.suiteTokenService.getSuiteAccessToken(corpId);
            for (int i = 0; i < size; ++i) {
                UserInfo u = (UserInfo)page.get(i);
                Integer departId = departIds[i];
                tasks.add(() -> {
                    List suiteUserList = this.userApi.list(suiteAccessToken, departId, Integer.valueOf(0));
                    if (CollectionUtils.isNotEmpty((Collection)suiteUserList)) {
                        UserInfo su = (UserInfo)suiteUserList.get(0);
                        this.merge(corpId, u.getUserId(), su.getUserId(), userIds, excludeDepartIds);
                    } else {
                        log.warn("NOT MATCHED: corpId={}, weworkUserId={}", (Object)corpId, (Object)u.getUserId());
                        this.create(corpId, u.getUserId(), departIds);
                    }
                    return null;
                });
            }
            try {
                this.executor.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            tasks.clear();
            timestamp = this.lock(corpId, timestamp);
            String contactAccessToken = this.corpTokenService.getContactAccessToken(corpId);
            for (int i = 0; i < size; ++i) {
                UserInfo u = (UserInfo)page.get(i);
                tasks.add(() -> {
                    this.userApi.updateDepartment(contactAccessToken, u.getUserId(), u.getDepartment());
                    return null;
                });
            }
            try {
                this.executor.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            tasks.clear();
            timestamp = this.lock(corpId, timestamp);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void merge(String corpId, String weworkUserId, String authUserId, Set<String> userIds, Set<Integer> excludeDepartIds) {
        User user;
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        WeworkUser authUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, authUserId);
        boolean isSame = weworkUserId.equals(authUserId);
        log.info("MATCHED corpId={}, weworkUserId:{}, authUserId:{}, weworkUser:{}, authUser:{}", new Object[]{corpId, weworkUserId, authUserId, weworkUser, authUser});
        if (weworkUser != null) {
            if (authUser != null && !isSame) {
                log.info("delete suite user, corpId={}, authUserId={}", (Object)corpId, (Object)authUserId);
                this.weworkUserMapper.deleteByPrimaryKey((Object)authUser.getId());
            }
            this.updateUserInfo(corpId, weworkUserId, weworkUser, excludeDepartIds);
            weworkUser.setAuthUserId(authUserId);
            weworkUser.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()));
            if (userIds.contains(authUserId) && weworkUser.getIsSuiteAuth() == 0) {
                weworkUser.setIsSuiteAuth(Integer.valueOf(1));
                weworkUser.setSuiteAuthTime(new Date());
            }
            weworkUser.setIsDeleted(Integer.valueOf(0));
            weworkUser.setUpdateTime(new Date());
            log.info("update corp user, corpId={}, weworkUserId={}", (Object)corpId, (Object)weworkUserId);
            this.weworkUserMapper.updateByPrimaryKey((Object)weworkUser);
        } else if (authUser != null) {
            this.updateUserInfo(corpId, weworkUserId, authUser, excludeDepartIds);
            authUser.setWeworkUserId(weworkUserId);
            authUser.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()));
            authUser.setIsDeleted(Integer.valueOf(0));
            authUser.setUpdateTime(new Date());
            log.info("update suite user, corpId={}, weworkUserId={}, authUserId={}", new Object[]{corpId, weworkUserId, authUserId});
            this.weworkUserMapper.updateByPrimaryKey((Object)authUser);
            weworkUser = authUser;
        } else {
            weworkUser = this.createSuiteUser(corpId, weworkUserId, authUserId, excludeDepartIds);
        }
        if (weworkUser != null && (user = this.userMapper.getByWeworkUserIdAndCorpId(weworkUserId, corpId)) == null) {
            log.info("create user, corpId={}, weworkUser={}", (Object)corpId, (Object)weworkUser);
            this.userService.insertUser(weworkUser, false);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(String corpId, String weworkUserId, Integer[] departIds) {
        log.info("NOT MATCHED corpId={}, weworkUserId:{}", (Object)corpId, (Object)weworkUserId);
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        if (weworkUser == null) {
            this.createCorpUser(corpId, weworkUserId);
        }
    }

    private Integer createDummyDepartment(String corpId, List<Integer> deptIds) {
        log.info("create dummy department, corpId={}, deptIds={}", (Object)corpId, deptIds);
        String contactAccessToken = this.corpTokenService.getContactAccessToken(corpId);
        if (contactAccessToken == null) {
            log.warn("\u7f3a\u5c11\u901a\u8baf\u5f55secret\uff0c\u65e0\u6cd5\u540c\u6b65\u6210\u5458\u8d26\u53f7\u3002");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f3a\u5c11\u901a\u8baf\u5f55secret\uff0c\u65e0\u6cd5\u540c\u6b65\u6210\u5458\u8d26\u53f7");
        }
        deptIds.sort(Integer::compareTo);
        int size = deptIds.size();
        Integer parentId = deptIds.get(size - 1);
        log.info("use parent departId={}", (Object)parentId);
        Department dept = new Department();
        dept.setParentId(parentId);
        dept.setName("DUMMY_" + this.idGen.getNum());
        Integer departId = null;
        try {
            departId = this.departmentApi.create(contactAccessToken, dept);
        }
        catch (WeworkException e) {
            log.warn("\u521b\u5efa\u90e8\u95e8\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u901a\u8baf\u5f55\u52a9\u624b\u6ca1\u6709API\u7f16\u8f91\u6743\u9650. corpId={}", (Object)corpId, (Object)e);
        }
        return departId;
    }

    private int calculateDepartmentCount(int userCunt) {
        if (userCunt <= 20) {
            return userCunt;
        }
        if (userCunt <= 100) {
            return 20;
        }
        if (userCunt <= 500) {
            return 50;
        }
        return 100;
    }

    private Integer[] createSyncDepartments(String corpId, Integer dummyDepartId, Integer[] departIds) {
        log.info("create dummy departments, corpId={}, dummyDepartId={}, count={}", new Object[]{corpId, dummyDepartId, departIds.length});
        String accessToken = this.corpTokenService.getContactAccessToken(corpId);
        for (int i = 0; i < departIds.length; ++i) {
            Department dept = new Department();
            dept.setParentId(dummyDepartId);
            dept.setName("dummy_" + i);
            departIds[i] = this.departmentApi.create(accessToken, dept);
        }
        return departIds;
    }

    private void deleteSyncDepartments(String corpId, Integer[] departIds) {
        log.info("delete sync department ids. corpId={}, departIds={}", (Object)corpId, (Object)departIds);
        if (departIds == null || departIds.length == 0) {
            return;
        }
        String contactAccessToken = this.corpTokenService.getContactAccessToken(corpId);
        for (int i = 0; i < departIds.length; ++i) {
            Integer deptId = departIds[i];
            if (deptId == null) continue;
            try {
                this.departmentApi.delete(contactAccessToken, deptId);
                continue;
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u90e8\u95e8\u5931\u8d25, deptId={}", (Object)deptId, (Object)e);
            }
        }
    }

    public WeworkUser createSuiteUser(String corpId, String weworkUserId, String authUserId, Set<Integer> departIds) {
        UserInfo userInfo;
        try {
            String accessToken = this.corpTokenService.getContactAccessToken(corpId);
            userInfo = this.userApi.get(accessToken, weworkUserId);
            log.info("fetch user info:{}", (Object)userInfo);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, weworkUserId:{}", new Object[]{e.getMessage(), corpId, weworkUserId});
            return null;
        }
        catch (Exception e) {
            log.error("fetch user info failed, corpId:{}, weworkUserId:{}", new Object[]{corpId, weworkUserId, e});
            return null;
        }
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        this.saveDepartmentUser(bizId, corpId, userInfo, departIds);
        WeworkUser weworkUser = this.newUser(bizId, corpId, userInfo);
        weworkUser.setAuthUserId(authUserId);
        weworkUser.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()));
        log.info("create suite user, corpId={}, weworkUserId={}, authUserId={}", new Object[]{corpId, weworkUserId, authUserId});
        this.weworkUserMapper.insertSelective((Object)weworkUser);
        return weworkUser;
    }

    public WeworkUser createCorpUser(String corpId, String weworkUserId) {
        UserInfo userInfo;
        try {
            String accessToken = this.corpTokenService.getContactAccessToken(corpId);
            userInfo = this.userApi.get(accessToken, weworkUserId);
            log.info("fetch user info:{}", (Object)userInfo);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, weworkUserId:{}", new Object[]{e.getMessage(), corpId, weworkUserId});
            return null;
        }
        catch (Exception e) {
            log.error("fetch user info failed, corpId:{}, weworkUserId:{}", new Object[]{corpId, weworkUserId, e});
            return null;
        }
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        WeworkUser weworkUser = this.newUser(bizId, corpId, userInfo);
        weworkUser.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.ONLY_CORP.getValue()));
        log.info("create corp user, corpId={}, weworkUserId={}", (Object)corpId, (Object)weworkUserId);
        this.weworkUserMapper.insertSelective((Object)weworkUser);
        return weworkUser;
    }

    private WeworkUser newUser(Long bizId, String corpId, UserInfo userInfo) {
        WeworkUser record = new WeworkUser();
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setWeworkUserId(userInfo.getUserId());
        record.setAuthUserId(userInfo.getUserId());
        record.setGender(Integer.valueOf(userInfo.getGender()));
        record.setStatus(Integer.valueOf(userInfo.getStatus()));
        record.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.ONLY_CORP.getValue()));
        record.setMainDepartment(userInfo.getMainDepartment());
        record.setOpenUserId(userInfo.getOpenUserId());
        record.setName(userInfo.getName());
        record.setAlias(userInfo.getAlias());
        record.setPosition(userInfo.getPosition());
        record.setMobile(userInfo.getMobile());
        record.setEmail(userInfo.getEmail());
        record.setAvatar(userInfo.getAvatar());
        record.setThumbAvatar(userInfo.getThumbAvatar());
        record.setTelephone(userInfo.getTelephone());
        record.setAddress(userInfo.getAddress());
        record.setQrCode(userInfo.getQrCode());
        record.setExternalPosition(userInfo.getExternalPosition());
        String exAttr = null;
        if (userInfo.getExtattr() != null) {
            exAttr = JacksonUtil.obj2Str((Object)userInfo.getExtattr().getAttrs());
        }
        record.setExtAttr(exAttr);
        String externalProfile = null;
        if (userInfo.getExternalProfile() != null) {
            externalProfile = JacksonUtil.obj2Str((Object)userInfo.getExternalProfile());
        }
        record.setExternalProfile(externalProfile);
        record.setNum(this.idGen.getNum());
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setIsDeleted(Integer.valueOf(0));
        return record;
    }

    public WeworkUser updateUserInfo(String corpId, String weworkUserId, WeworkUser weworkUser, Set<Integer> excludeDepartIds) {
        UserInfo userInfo = null;
        try {
            String accessToken = this.corpTokenService.getContactAccessToken(corpId);
            userInfo = this.userApi.get(accessToken, weworkUserId);
            log.info("update user info:{}", (Object)userInfo);
            this.updateUser(weworkUser, userInfo);
            Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
            this.saveDepartmentUser(bizId, corpId, userInfo, excludeDepartIds);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, weworkUserId:{}", new Object[]{e.getMessage(), corpId, weworkUserId});
        }
        catch (Exception e) {
            log.error("fetch user info failed, corpId:{}, weworkUserId:{}", new Object[]{corpId, weworkUserId, e});
        }
        return weworkUser;
    }

    private WeworkUser updateUser(WeworkUser record, UserInfo userInfo) {
        record.setGender(Integer.valueOf(userInfo.getGender()));
        record.setStatus(Integer.valueOf(userInfo.getStatus()));
        record.setMainDepartment(userInfo.getMainDepartment());
        record.setOpenUserId(userInfo.getOpenUserId());
        record.setName(userInfo.getName());
        record.setAlias(userInfo.getAlias());
        record.setPosition(userInfo.getPosition());
        record.setMobile(userInfo.getMobile());
        record.setEmail(userInfo.getEmail());
        record.setAvatar(userInfo.getAvatar());
        record.setThumbAvatar(userInfo.getThumbAvatar());
        record.setTelephone(userInfo.getTelephone());
        record.setAddress(userInfo.getAddress());
        record.setQrCode(userInfo.getQrCode());
        record.setExternalPosition(userInfo.getExternalPosition());
        String exAttr = null;
        if (userInfo.getExtattr() != null) {
            exAttr = JacksonUtil.obj2Str((Object)userInfo.getExtattr().getAttrs());
        }
        record.setExtAttr(exAttr);
        String externalProfile = null;
        if (userInfo.getExternalProfile() != null) {
            externalProfile = JacksonUtil.obj2Str((Object)userInfo.getExternalProfile());
        }
        record.setExternalProfile(externalProfile);
        return record;
    }

    private void saveDepartmentUser(Long bizId, String corpId, UserInfo userInfo, Set<Integer> excludeDepartIds) {
        String weworkUserId = userInfo.getUserId();
        List departmentIds = userInfo.getDepartment();
        List isLeaders = userInfo.getIsLeaderInDept();
        List orders = userInfo.getOrder();
        Date now = new Date();
        ArrayList insertList = Lists.newArrayList();
        List exists = this.weworkDepartmentUserMapper.selectExistDepartmentUser(corpId, weworkUserId);
        if (CollectionUtils.isEmpty((Collection)departmentIds)) {
            log.info("department is empty, corpId:{}, userId:{}", (Object)corpId, (Object)weworkUserId);
            if (CollectionUtils.isNotEmpty((Collection)exists)) {
                List ids = exists.stream().map(it -> it.getId()).collect(Collectors.toList());
                this.weworkDepartmentUserMapper.delDepartmentUser(ids);
                log.info("delete wework_department_user, ids:{}", ids);
            }
            return;
        }
        Map<Object, Object> existMap = CollectionUtils.isNotEmpty((Collection)exists) ? exists.stream().collect(Collectors.toMap(it -> it.getDepartmentId(), it -> it)) : Maps.newHashMap();
        for (int i = 0; i < departmentIds.size(); ++i) {
            Integer departmentId = (Integer)departmentIds.get(i);
            Integer isLeader = (Integer)isLeaders.get(i);
            Integer order = (Integer)orders.get(i);
            if (excludeDepartIds.contains(departmentId)) continue;
            WeworkDepartmentUser record = (WeworkDepartmentUser)existMap.remove(departmentId);
            if (record == null) {
                record = new WeworkDepartmentUser();
                record.setBizId(bizId);
                record.setCorpId(corpId);
                record.setWeworkUserId(weworkUserId);
                record.setDepartmentId(departmentId);
                record.setCreateTime(now);
            }
            record.setIsLeaderInDept(isLeader);
            record.setOrder(order);
            record.setUpdateTime(now);
            record.setIsDeleted(Integer.valueOf(0));
            insertList.add(record);
        }
        this.weworkDepartmentUserMapper.batchInsert((Collection)insertList);
        if (!existMap.isEmpty()) {
            List ids = existMap.values().stream().map(it -> it.getId()).collect(Collectors.toList());
            this.weworkDepartmentUserMapper.delDepartmentUser(ids);
        }
    }

    private String key(String authCorpId) {
        return this.prefix + "SYNC_AUTH_CORP:" + authCorpId;
    }

    private Long lock(String corpId, Long timestamp) {
        String key = this.key(corpId);
        Long current = System.currentTimeMillis();
        if (timestamp == null || current - timestamp > 60000L) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)"true", 300L, TimeUnit.SECONDS);
        }
        return current;
    }

    private void unlock(String corpId) {
        String key = this.key(corpId);
        this.redisTemplate.opsForValue().set((Object)key, (Object)"false", 10L, TimeUnit.SECONDS);
    }

    @Override
    public boolean isMatching(String corpId) {
        String key = this.key(corpId);
        String value = (String)this.redisTemplate.opsForValue().get((Object)key);
        return value != null;
    }
}

