/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.crm.common.service.dto.req.CrmModMobileReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.wework.sdk.api.external.ExternalContactApi;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactInfo;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactResp;
import cn.kinyun.wework.sdk.entity.external.contact.FollowUser;
import cn.kinyun.wework.sdk.entity.external.contact.Tag;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.contactStage.entity.WeworkContactStage;
import com.kuaike.scrm.dal.contactStage.mapper.WeworkContactStageMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.telAddFriend.entity.TelAddFriendTask;
import com.kuaike.scrm.dal.telAddFriend.entity.TelAddFriendTaskDetail;
import com.kuaike.scrm.dal.telAddFriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.telAddFriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserIdContactIdDto;
import com.kuaike.scrm.dal.wework.dto.WeworkUserNumContactIdDto;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactMobile;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworkTag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.synctask.service.ExternalContactSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExternalContactSyncServiceImpl
implements ExternalContactSyncService {
    private static final Logger log = LoggerFactory.getLogger(ExternalContactSyncServiceImpl.class);
    @Autowired
    @Qualifier(value="synctaskThreadPool")
    private ExecutorService executorService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ExternalContactApi externalContactApi;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Autowired
    private WeworkContactStageMapper weworkContactStageMapper;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Resource
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Resource
    private TelAddFriendTaskMapper telAddFriendTaskMapper;

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Integer devStatus = this.customizedTokenService.getAuthStatus(bizId);
        if (devStatus == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        if (devStatus.intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210");
        }
        return this.syncTaskService.start(bizId, corpId, SyncTaskType.EXTERNAL_CONTACT, operatorId);
    }

    @Override
    public void fetch(String corpId) {
        log.info("fetch external contact, corpId:{}", (Object)corpId);
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        List userIds = this.weworkUserMapper.queryAccessWeworkUserIds(corpId);
        log.info("user ids:{}", (Object)userIds);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            log.info("userIds is empty, corpId:{}", (Object)corpId);
            return;
        }
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (accessToken == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        log.info("sync access token:{}", (Object)accessToken);
        Map<String, List<String>> userContactMap = this.fetchUserContactIds(corpId, userIds, accessToken);
        TreeSet externalUserIdSet = new TreeSet();
        userContactMap.forEach((k, v) -> externalUserIdSet.addAll(v));
        ArrayList externalUserIds = Lists.newArrayList(externalUserIdSet);
        List pages = Lists.partition((List)externalUserIds, (int)500);
        for (List page : pages) {
            try {
                this.batchSaveContact(bizId, corpId, page, accessToken);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u4fdd\u5b58\u5ba2\u6237\u6570\u636e\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
            }
        }
        this.initContactStage(bizId, corpId);
        this.syncTaskService.start(bizId, corpId, SyncTaskType.CONTACT_MOBILE, -1L);
    }

    private Map<String, List<String>> fetchUserContactIds(final String corpId, List<String> userIds, final String accessToken) {
        log.info("fetch user contact, corpId:{}, userIds:{}", (Object)corpId, userIds);
        final HashMap map = Maps.newHashMap();
        int capacity = userIds.size();
        ArrayList fetchTasks = Lists.newArrayListWithCapacity((int)capacity);
        final ArrayList exceptions = Lists.newArrayListWithCapacity((int)capacity);
        for (final String weworkUserId : userIds) {
            Callable<Void> task = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    block8: {
                        try {
                            List externalUserIds = ExternalContactSyncServiceImpl.this.fetchContactIds(corpId, weworkUserId, accessToken);
                            if (externalUserIds == null) break block8;
                            Map map2 = map;
                            synchronized (map2) {
                                map.put(weworkUserId, externalUserIds);
                            }
                        }
                        catch (Exception e) {
                            List list = exceptions;
                            synchronized (list) {
                                exceptions.add(e);
                            }
                        }
                    }
                    return null;
                }
            };
            fetchTasks.add(task);
        }
        try {
            this.executorService.invokeAll(fetchTasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            log.error("invoke synctask failed", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c9\u53d6\u6570\u636e\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)exceptions)) {
            log.info("fetch external contact error:{}", (Object)exceptions.size());
            Exception e = (Exception)exceptions.get(0);
            if (e instanceof BusinessException) {
                throw (BusinessException)e;
            }
            if (e instanceof WeworkException) {
                throw (WeworkException)((Object)e);
            }
            throw new RuntimeException(e);
        }
        return map;
    }

    private List<String> fetchContactIds(String corpId, String weworkUserId, String accessToken) {
        try {
            List externalUserIds = this.externalContactApi.list(accessToken, weworkUserId);
            return externalUserIds;
        }
        catch (WeworkException e) {
            if (e.getErrorCode() == 84061) {
                log.warn("\u4e0d\u5b58\u5728\u5916\u90e8\u8054\u7cfb\u4eba\u5173\u7cfb, userId:{}", (Object)weworkUserId);
                return Collections.emptyList();
            }
            if (e.getErrorCode() == 60011) {
                log.warn("\u8be5\u6210\u5458\u6ca1\u6709\u914d\u7f6e\u5ba2\u6237\u8054\u7cfb\u6743\u9650, userId:{}", (Object)weworkUserId);
                return Collections.emptyList();
            }
            log.error("{}, userId:{}", (Object)e.getMessage(), (Object)weworkUserId);
            throw e;
        }
        catch (Exception e) {
            log.error("failed to get external contact, userId:{}", (Object)weworkUserId, (Object)e);
            throw e;
        }
    }

    private List<ExternalContactResp> fetchContactDetailList(List<String> externalUserIds, final String accessToken) {
        log.info("fetch user contact detail, externalUserIds:{}", externalUserIds);
        int capacity = externalUserIds.size();
        final ArrayList fetchList = Lists.newArrayListWithCapacity((int)capacity);
        ArrayList fetchTasks = Lists.newArrayListWithCapacity((int)capacity);
        final ArrayList exceptions = Lists.newArrayListWithCapacity((int)capacity);
        for (final String externalUserId : externalUserIds) {
            Callable<Void> task = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    block8: {
                        try {
                            ExternalContactResp detail = ExternalContactSyncServiceImpl.this.fetchContactDetail(externalUserId, accessToken);
                            if (detail == null) break block8;
                            List list = fetchList;
                            synchronized (list) {
                                fetchList.add(detail);
                            }
                        }
                        catch (Exception e) {
                            List list = exceptions;
                            synchronized (list) {
                                exceptions.add(e);
                            }
                        }
                    }
                    return null;
                }
            };
            fetchTasks.add(task);
        }
        try {
            this.executorService.invokeAll(fetchTasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            log.error("invoke synctask failed", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c9\u53d6\u6570\u636e\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)exceptions)) {
            log.info("fetch external contact error:{}", (Object)exceptions.size());
            Exception e = (Exception)exceptions.get(0);
            if (e instanceof BusinessException) {
                throw (BusinessException)e;
            }
            if (e instanceof WeworkException) {
                throw (WeworkException)((Object)e);
            }
            throw new RuntimeException(e);
        }
        return fetchList;
    }

    private ExternalContactResp fetchContactDetail(String externalUserId, String accessToken) {
        ExternalContactResp result;
        boolean flag = false;
        String cursor = null;
        ArrayList followUsers = Lists.newArrayList();
        do {
            result = this.externalContactApi.getDetail(accessToken, externalUserId, cursor);
            cursor = result.getNextCursor();
            ExternalContactInfo externalContact = result.getExternalContact();
            List followUserList = result.getFollowUserList();
            if (!flag) {
                log.info("contact detail:{}", (Object)externalContact);
            }
            flag = true;
            if (!CollectionUtils.isNotEmpty((Collection)followUserList)) continue;
            log.info("followUser:{}", (Object)followUserList);
            followUsers.addAll(followUserList);
        } while (cursor != null);
        result.setFollowUserList((List)followUsers);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSaveContact(Long bizId, String corpId, List<String> externalUserIds, String accessToken) {
        Set ids;
        log.info("batch save contact, bizId:{}, corpId:{}, externalUserIds:{}", new Object[]{bizId, corpId, externalUserIds});
        List<ExternalContactResp> fetchList = this.fetchContactDetailList(externalUserIds, accessToken);
        ArrayList addContactList = Lists.newArrayList();
        ArrayList addRelationList = Lists.newArrayList();
        ArrayList addTagList = Lists.newArrayList();
        ArrayList addMobileList = Lists.newArrayList();
        ArrayList delTagList = Lists.newArrayList();
        ArrayList delMobileList = Lists.newArrayList();
        List existsContactList = this.weworkContactMapper.queryWeworkContactList(corpId, externalUserIds);
        Map<Object, Object> existsContactMap = CollectionUtils.isNotEmpty((Collection)existsContactList) ? existsContactList.stream().collect(Collectors.toMap(it -> it.getContactId(), it -> it)) : Collections.emptyMap();
        String contactFormat = "%s##%s";
        List existsRelationList = this.weworkContactRelationMapper.queryByCorpIdAndContactIds(corpId, externalUserIds);
        Map<Object, Object> existsRelationMap = CollectionUtils.isNotEmpty((Collection)existsRelationList) ? existsRelationList.stream().collect(Collectors.toMap(it -> String.format(contactFormat, it.getContactId(), it.getWeworkUserId()), it -> it)) : Collections.emptyMap();
        List existsTagList = this.weworkContactTagMapper.queryByCorpIdAndContactIds(corpId, externalUserIds);
        Map<Object, Object> existsTagListMap = CollectionUtils.isNotEmpty((Collection)existsTagList) ? existsTagList.stream().collect(Collectors.groupingBy(it -> String.format(contactFormat, it.getContactId(), it.getWeworkUserId()))) : Collections.emptyMap();
        List existsMobileList = this.weworkContactMobileMapper.queryByCorpIdAndContactIds(corpId, externalUserIds);
        Map<Object, Object> existsMobileListMap = CollectionUtils.isNotEmpty((Collection)existsMobileList) ? existsMobileList.stream().collect(Collectors.groupingBy(it -> String.format(contactFormat, it.getContactId(), it.getWeworkUserId()))) : Collections.emptyMap();
        Long channelId = this.channelMapper.querySysChannelId(SysChannelEnum.QY_WEIXIN.getCode());
        Map weworkUserIdNumMap = this.weworkUserMapper.queryWeworkUserIdNumMapByCorpId(corpId);
        for (ExternalContactResp externalContactResp : fetchList) {
            ExternalContactInfo contact = externalContactResp.getExternalContact();
            String contactId = contact.getExternalUserId();
            WeworkContact existContact = (WeworkContact)existsContactMap.remove(contactId);
            if (this.diffContact(existContact, contact)) {
                addContactList.add(this.newContact(bizId, corpId, contact));
            }
            List followUserList = externalContactResp.getFollowUserList();
            log.info("contactId: {} of followUserList: {}", (Object)contactId, (Object)followUserList);
            if (CollectionUtils.isEmpty((Collection)followUserList)) continue;
            String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(bizId, contactId, null);
            for (FollowUser followUser : followUserList) {
                String contactKey = String.format(contactFormat, contactId, followUser.getUserId());
                WeworkContactRelation existRelation = (WeworkContactRelation)existsRelationMap.remove(contactKey);
                if (this.diffRelation(existRelation, followUser, null)) {
                    addRelationList.add(this.newRelation(bizId, corpId, contactId, followUser, null));
                }
                Map<String, List<WeworkContactTag>> existsTagMap = Collections.emptyMap();
                List existsTags = (List)existsTagListMap.remove(contactKey);
                if (CollectionUtils.isNotEmpty((Collection)existsTags)) {
                    existsTagMap = existsTags.stream().collect(Collectors.groupingBy(it -> this.tagKey((WeworkContactTag)it)));
                }
                List<WeworkContactTag> addTags = this.newTagList(bizId, corpId, contactId, followUser, existsTagMap);
                addTagList.addAll(addTags);
                ArrayList delTagIds = Lists.newArrayList();
                if (!existsTagMap.isEmpty()) {
                    for (List<WeworkContactTag> it2 : existsTagMap.values()) {
                        delTagList.addAll(it2);
                        delTagIds.addAll(it2.stream().map(item -> item.getTagId()).collect(Collectors.toList()));
                    }
                }
                String weworkUserNum = (String)weworkUserIdNumMap.get(followUser.getUserId());
                List addTgaIds = addTags.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTagId())).map(it -> it.getTagId()).collect(Collectors.toList());
                log.info("push tag relation customer: {}", (Object)customerNum);
                this.customerCenterService.pushTagRelation(bizId, weworkUserNum, customerNum, addTgaIds, (List)delTagIds);
                Map<String, List<WeworkContactMobile>> existsMobileMap = Collections.emptyMap();
                List existsMobiles = (List)existsMobileListMap.remove(contactKey);
                if (CollectionUtils.isNotEmpty((Collection)existsMobiles)) {
                    existsMobileMap = existsMobiles.stream().collect(Collectors.groupingBy(it -> it.getRemarkMobile()));
                }
                addMobileList.addAll(this.newMobileList(bizId, corpId, contactId, followUser, existsMobileMap));
                if (existsMobileMap.isEmpty()) continue;
                for (List<WeworkContactMobile> it3 : existsMobileMap.values()) {
                    delMobileList.addAll(it3);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addContactList)) {
            log.info("save contact:{}", (Object)addContactList.size());
            Lists.partition((List)addContactList, (int)200).forEach(list -> this.weworkContactMapper.batchInsert(list));
            Map tagIds = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)addTagList)) {
                tagIds = addTagList.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getTagId())).collect(Collectors.groupingBy(WeworkContactTag::getContactId, Collectors.mapping(WeworkContactTag::getTagId, Collectors.toList())));
            }
            for (ExternalContactInfo contact : addContactList) {
                this.customerCenterService.pushContactCustomer((WeworkContact)contact);
                if (!StringUtils.isNotEmpty((CharSequence)contact.getMobile())) continue;
                String moduleType = ModuleType.BATCH_ADD_FRIEND.getCode();
                this.customerCenterService.pushAddMobileEvent(contact.getBizId(), contact.getMobile(), moduleType);
                this.customerCenterService.pushMobileCustomer(contact.getBizId(), contact.getMobile(), contact.getName(), tagIds.get(contact.getContactId()), Long.valueOf(-1L), channelId);
                this.customerCenterService.bindCustomer(contact.getBizId(), contact.getCorpId(), contact.getContactId(), contact.getMobile(), moduleType);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addRelationList)) {
            log.info("save contact relation:{}", (Object)addRelationList.size());
            Lists.partition((List)addRelationList, (int)200).forEach(list -> this.weworkContactRelationMapper.batchInsert(list));
            for (WeworkContactRelation weworkContactRelation : addRelationList) {
                this.customerCenterService.pushContactRelation(weworkContactRelation);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addTagList)) {
            log.info("save contact tag:{}", (Object)addTagList.size());
            Lists.partition((List)addTagList, (int)200).forEach(list -> this.weworkContactTagMapper.batchInsert(list));
        }
        if (CollectionUtils.isNotEmpty((Collection)addMobileList)) {
            log.info("save contact mobile:{}", (Object)addMobileList.size());
            this.weworkContactMobileMapper.batchInsert((List)addMobileList);
        }
        if (!existsRelationMap.isEmpty()) {
            ids = existsRelationMap.values().stream().map(it -> it.getId()).collect(Collectors.toSet());
            log.info("delete contact relation size:{}, ids:{}", (Object)ids.size(), ids);
            this.weworkContactRelationMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
            for (Long contactRelationId : ids) {
                WeworkContactRelation delContactRelation = (WeworkContactRelation)this.weworkContactRelationMapper.selectByPrimaryKey((Object)contactRelationId);
                this.customerCenterService.pushContactRelation(delContactRelation);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)delTagList)) {
            ids = delTagList.stream().map(it -> it.getId()).collect(Collectors.toSet());
            log.info("delete contact tag size:{}, ids:{}", (Object)ids.size(), ids);
            this.weworkContactTagMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
        }
        if (CollectionUtils.isNotEmpty((Collection)delMobileList)) {
            ids = delMobileList.stream().map(it -> it.getId()).collect(Collectors.toSet());
            log.info("delete contact mobile size:{}, ids:{}", (Object)ids.size(), ids);
            this.weworkContactMobileMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
        }
    }

    private boolean diffContact(WeworkContact exist, ExternalContactInfo contact, String mobile) {
        boolean result = this.diffContact(exist, contact);
        if (result) {
            return result;
        }
        if (!com.google.common.base.Objects.equal((Object)mobile, (Object)exist.getMobile())) {
            log.info("mobile diff:\n{}\n{}", (Object)mobile, (Object)exist.getMobile());
            result = true;
        }
        return result;
    }

    private boolean diffContact(WeworkContact exist, ExternalContactInfo contact) {
        if (exist == null) {
            log.info("contact not exist");
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getName(), (Object)exist.getName())) {
            log.info("name diff:\n{}\n{}", (Object)contact.getName(), (Object)exist.getName());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getAvatar(), (Object)exist.getAvatar())) {
            log.info("avatar diff:\n{}\n{}", (Object)contact.getAvatar(), (Object)exist.getAvatar());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getGender(), (Object)exist.getGender())) {
            log.info("gender diff:\n{}\n{}", (Object)contact.getGender(), (Object)exist.getGender());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getUnionId(), (Object)exist.getUnionid())) {
            log.info("unionid diff:\n{}\n{}", (Object)contact.getUnionId(), (Object)exist.getUnionid());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getType(), (Object)exist.getType())) {
            log.info("type diff:\n{}\n{}", (Object)contact.getType(), (Object)exist.getType());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getPosition(), (Object)exist.getPosition())) {
            log.info("position diff:\n{}\n{}", (Object)contact.getPosition(), (Object)exist.getPosition());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getCorpName(), (Object)exist.getCorpName())) {
            log.info("corpName diff:\n{}\n{}", (Object)contact.getCorpName(), (Object)exist.getCorpName());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getCorpFullName(), (Object)exist.getCorpFullName())) {
            log.info("corpFullName diff:\n{}\n{}", (Object)contact.getCorpFullName(), (Object)exist.getCorpFullName());
            return true;
        }
        String externalProfile = "";
        if (contact.getExternalProfile() != null) {
            externalProfile = JacksonUtil.obj2Str((Object)contact.getExternalProfile());
        }
        if (!com.google.common.base.Objects.equal((Object)externalProfile, (Object)exist.getExternalProfile())) {
            log.info("externalProfile diff:\n{}\n{}", (Object)externalProfile, (Object)exist.getExternalProfile());
            return true;
        }
        return false;
    }

    private boolean diffRelation(WeworkContactRelation exist, FollowUser followUser, Integer isZombieFans) {
        if (exist == null) {
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getRemark(), (Object)exist.getRemark())) {
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getDescription(), (Object)exist.getDescription())) {
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getRemarkCorpName(), (Object)exist.getRemarkCorpName())) {
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getAddWay(), (Object)exist.getAddWay())) {
            return true;
        }
        Long addTime = null;
        if (exist.getAddTime() != null) {
            addTime = exist.getAddTime().getTime() / 1000L;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getCreateTime(), addTime)) {
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getOperUserId(), (Object)exist.getOperUserId())) {
            return true;
        }
        Integer tagCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)followUser.getTags())) {
            for (Tag tag : followUser.getTags()) {
                if (tag.getType() != 1) continue;
                Integer n = tagCount;
                Integer n2 = tagCount = Integer.valueOf(tagCount + 1);
            }
        }
        if (!com.google.common.base.Objects.equal((Object)tagCount, (Object)exist.getTagCount())) {
            return true;
        }
        Integer mobileCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)followUser.getRemarkMobiles())) {
            mobileCount = followUser.getRemarkMobiles().size();
        }
        if (!com.google.common.base.Objects.equal((Object)mobileCount, (Object)exist.getMobileCount())) {
            return true;
        }
        return isZombieFans != null && !com.google.common.base.Objects.equal((Object)isZombieFans, (Object)exist.getIsZombieFans());
    }

    private WeworkContact newContact(Long bizId, String corpId, ExternalContactInfo contact) {
        WeworkContact record = new WeworkContact();
        record.setNum(this.idGen.getNum());
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setContactId(contact.getExternalUserId());
        record.setUnionid(contact.getUnionId());
        record.setName(contact.getName());
        record.setAvatar(contact.getAvatar());
        record.setGender(contact.getGender());
        record.setType(contact.getType());
        record.setPosition(contact.getPosition());
        record.setCorpName(contact.getCorpName());
        record.setCorpFullName(contact.getCorpFullName());
        String externalProfile = "";
        if (contact.getExternalProfile() != null) {
            externalProfile = JacksonUtil.obj2Str((Object)contact.getExternalProfile());
        }
        record.setExternalProfile(externalProfile);
        Date now = new Date();
        record.setCreateTime(now);
        record.setUpdateTime(now);
        return record;
    }

    private WeworkContactRelation newRelation(Long bizId, String corpId, String contactId, FollowUser followUser, Integer isZombieFans) {
        Integer tagCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)followUser.getTags())) {
            for (Tag tag : followUser.getTags()) {
                if (tag.getType() != 1) continue;
                Integer n = tagCount;
                Integer n2 = tagCount = Integer.valueOf(tagCount + 1);
            }
        }
        Integer mobileCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)followUser.getRemarkMobiles())) {
            mobileCount = followUser.getRemarkMobiles().size();
        }
        WeworkContactRelation record = new WeworkContactRelation();
        String weworkUserId = followUser.getUserId();
        record.setNum(this.idGen.getNum());
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setWeworkUserId(weworkUserId);
        record.setContactId(contactId);
        record.setRemark(followUser.getRemark());
        record.setRemarkCorpName(followUser.getRemarkCorpName());
        record.setDescription(followUser.getDescription());
        record.setTagCount(tagCount);
        record.setMobileCount(mobileCount);
        if (isZombieFans != null) {
            record.setIsZombieFans(isZombieFans);
        }
        record.setOperUserId(followUser.getOperUserId());
        record.setAddWay(followUser.getAddWay());
        record.setAddTime(new Date(followUser.getCreateTime() * 1000L));
        Date now = new Date();
        record.setCreateBy(Long.valueOf(-1L));
        record.setCreateTime(now);
        record.setUpdateBy(Long.valueOf(-1L));
        record.setUpdateTime(now);
        return record;
    }

    private List<WeworkContactTag> newTagList(Long bizId, String corpId, String contactId, FollowUser followUser, Map<String, List<WeworkContactTag>> existsTagMap) {
        String weworkUserId = followUser.getUserId();
        ArrayList list = Lists.newArrayList();
        List tags = followUser.getTags();
        if (CollectionUtils.isEmpty((Collection)tags)) {
            return Collections.emptyList();
        }
        for (Tag tag : tags) {
            String key = this.tagKey(tag);
            if (existsTagMap.containsKey(key)) {
                existsTagMap.remove(key);
                continue;
            }
            list.add(this.newTag(bizId, corpId, weworkUserId, contactId, tag));
        }
        return list;
    }

    private WeworkContactTag newTag(Long bizId, String corpId, String weworkUserId, String contactId, Tag tag) {
        WeworkContactTag record = new WeworkContactTag();
        record.setNum(this.idGen.getNum());
        log.info("num:{}", (Object)this.idGen.getNum());
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setWeworkUserId(weworkUserId);
        record.setContactId(contactId);
        record.setType(tag.getType());
        if (tag.getType() == 1) {
            record.setTagId(tag.getTagId());
        } else {
            record.setTagName(tag.getTagName());
        }
        Date now = new Date();
        record.setCreateBy(Long.valueOf(-1L));
        record.setCreateTime(now);
        record.setUpdateBy(Long.valueOf(-1L));
        record.setUpdateTime(now);
        return record;
    }

    private String tagKey(WeworkContactTag tag) {
        if (tag.getType() == 1) {
            return "1##" + tag.getTagId();
        }
        return "2##" + tag.getTagName();
    }

    private String tagKey(Tag tag) {
        if (tag.getType() == 1) {
            return "1##" + tag.getTagId();
        }
        return "2##" + tag.getTagName();
    }

    private List<WeworkContactMobile> newMobileList(Long bizId, String corpId, String contactId, FollowUser followUser, Map<String, List<WeworkContactMobile>> existsMobileMap) {
        ArrayList list = Lists.newArrayList();
        List mobiles = followUser.getRemarkMobiles();
        String weworkUserId = followUser.getUserId();
        if (CollectionUtils.isEmpty((Collection)mobiles)) {
            return Collections.emptyList();
        }
        for (String mobile : mobiles) {
            if (existsMobileMap.containsKey(mobile)) {
                existsMobileMap.remove(mobile);
                continue;
            }
            list.add(this.newMobile(bizId, corpId, weworkUserId, contactId, mobile));
        }
        return list;
    }

    private WeworkContactMobile newMobile(Long bizId, String corpId, String weworkUserId, String contactId, String mobile) {
        WeworkContactMobile record = new WeworkContactMobile();
        record.setNum(this.idGen.getNum());
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setWeworkUserId(weworkUserId);
        record.setContactId(contactId);
        record.setRemarkMobile(mobile);
        Date now = new Date();
        record.setCreateBy(Long.valueOf(-1L));
        record.setCreateTime(now);
        record.setUpdateBy(Long.valueOf(-1L));
        record.setUpdateTime(now);
        return record;
    }

    private WeworkContactStage newContactStage(Long bizId, String corpId, String weworkUserNum, String contactId, CustomerStage defaultStage) {
        WeworkContactStage record = new WeworkContactStage();
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setContactId(contactId);
        record.setWeworkUserNum(weworkUserNum);
        record.setStatus(Integer.valueOf(0));
        record.setStageId(defaultStage.getId());
        record.setRemark("");
        record.setFinalStageId(null);
        record.setStageReasonId(null);
        record.setUpdateBy(Long.valueOf(-1L));
        record.setCreateBy(Long.valueOf(-1L));
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setIsDeleted(Integer.valueOf(0));
        return record;
    }

    private void initContactStage(Long bizId, String corpId) {
        log.info("init contact stage, bizId:{}, corpId:{}", (Object)bizId, (Object)corpId);
        CustomerStage defaultStage = this.customerStageMapper.queryFirstStage(bizId, corpId);
        if (defaultStage == null) {
            log.warn("\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4e0b\u7684\u521d\u59cb\u8ddf\u8fdb\u9636\u6bb5\uff0cbizId:{}, corpId:{}", (Object)bizId, (Object)corpId);
            return;
        }
        ArrayList addList = Lists.newArrayList();
        List stageList = this.weworkContactStageMapper.selectExistStageByCorpId(corpId);
        HashSet stageSet = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)stageList)) {
            for (WeworkUserNumContactIdDto it : stageList) {
                String val = it.getWeworkUserNum() + "##" + it.getContactId();
                stageSet.add(val);
            }
        }
        Map weworkUserIdNumMap = this.weworkUserMapper.queryWeworkUserIdNumMapByCorpId(corpId);
        List relationList = this.weworkContactRelationMapper.selectExistRelationByCorpId(corpId);
        if (CollectionUtils.isNotEmpty((Collection)relationList)) {
            for (WeworkUserIdContactIdDto it : relationList) {
                String val;
                String weworkUserId = it.getWeworkUserId();
                String contactId = it.getContactId();
                String weworkUserNum = (String)weworkUserIdNumMap.get(weworkUserId);
                if (weworkUserNum == null || stageSet.contains(val = weworkUserNum + "##" + contactId)) continue;
                addList.add(this.newContactStage(bizId, corpId, weworkUserNum, contactId, defaultStage));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            log.info("save wework_contact_stage, count:{}", (Object)addList.size());
            Lists.partition((List)addList, (int)200).forEach(list -> this.weworkContactStageMapper.batchInsert(list));
            for (WeworkContactStage stage : addList) {
                this.customerCenterService.pushCustomerStage(stage);
            }
        }
    }

    private void initContactStage(Long bizId, String corpId, String weworkUserId, String contactId) {
        String num = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, weworkUserId);
        int count = this.weworkContactStageMapper.countContactStage(corpId, num, contactId);
        if (count <= 0) {
            log.info("initialize wework contact stage, corpId:{}, weworkUserId:{}, contactId:{}", new Object[]{corpId, weworkUserId, contactId});
            CustomerStage defaultStage = this.customerStageMapper.queryFirstStage(bizId, corpId);
            if (defaultStage == null) {
                log.warn("\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4e0b\u7684\u521d\u59cb\u8ddf\u8fdb\u9636\u6bb5\uff0cbizId:{}, corpId:{}", (Object)bizId, (Object)corpId);
                return;
            }
            WeworkContactStage stage = this.newContactStage(bizId, corpId, num, contactId, defaultStage);
            this.weworkContactStageMapper.batchInsert(Collections.singletonList(stage));
            this.customerCenterService.pushCustomerStage(stage);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void modifyExternalContact(String accessToken, String corpId, String userId, String externalUserId, Long timestamp, boolean isAdd) {
        void var31_38;
        User user;
        log.info("modify external contact, corpId:{}, userId:{}, externalUserId:{}, timestamp:{}", new Object[]{corpId, userId, externalUserId, timestamp});
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        ExternalContactResp result = null;
        try {
            result = this.fetchContactDetail(externalUserId, accessToken);
        }
        catch (Exception e) {
            log.error("Failed fetch contact detail, externalUserId:{}", (Object)externalUserId, (Object)e);
            return;
        }
        ExternalContactInfo contact = result.getExternalContact();
        if (contact == null) {
            log.warn("external contact info is null");
            return;
        }
        FollowUser followUser = null;
        if (CollectionUtils.isNotEmpty((Collection)result.getFollowUserList())) {
            for (FollowUser it2 : result.getFollowUserList()) {
                if (!userId.equals(it2.getUserId())) continue;
                followUser = it2;
                break;
            }
        }
        if (followUser == null) {
            log.warn("follow user is null");
            return;
        }
        WeworkContact existContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, externalUserId);
        WeworkContactRelation existRelation = this.weworkContactRelationMapper.get(corpId, userId, externalUserId);
        List existsTags = this.weworkContactTagMapper.queryContactTags(corpId, userId, externalUserId, Integer.valueOf(0));
        List existsMobiles = this.weworkContactMobileMapper.queryContactMobiles(corpId, userId, externalUserId);
        ReplyContextUtil.get().setNewCustomer(existContact == null);
        List<Object> addContactList = Collections.emptyList();
        String mobile = null;
        if (CollectionUtils.isNotEmpty((Collection)followUser.getRemarkMobiles())) {
            mobile = (String)followUser.getRemarkMobiles().get(0);
        }
        if (this.diffContact(existContact, contact, mobile)) {
            addContactList = Collections.singletonList(this.newContact(bizId, corpId, contact));
        }
        Integer isZombieFans = null;
        if (isAdd) {
            isZombieFans = 0;
        }
        List<Object> addRelationList = Collections.emptyList();
        if (this.diffRelation(existRelation, followUser, isZombieFans)) {
            addRelationList = Collections.singletonList(this.newRelation(bizId, corpId, externalUserId, followUser, isZombieFans));
        }
        Map<String, List<WeworkContactTag>> existsTagMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)existsTags)) {
            existsTagMap = existsTags.stream().collect(Collectors.groupingBy(it -> this.tagKey((WeworkContactTag)it)));
        }
        List<WeworkContactTag> addTagList = this.newTagList(bizId, corpId, externalUserId, followUser, existsTagMap);
        ArrayList delTagList = Collections.emptyList();
        if (!existsTagMap.isEmpty()) {
            delTagList = Lists.newArrayList();
            for (List<WeworkContactTag> it3 : existsTagMap.values()) {
                delTagList.addAll(it3);
            }
        }
        Map<String, List<WeworkContactMobile>> existsMobileMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)existsMobiles)) {
            existsMobileMap = existsMobiles.stream().collect(Collectors.groupingBy(it -> it.getRemarkMobile()));
        }
        List<WeworkContactMobile> addMobileList = this.newMobileList(bizId, corpId, externalUserId, followUser, existsMobileMap);
        ArrayList delMobileList = Collections.emptyList();
        if (!existsMobileMap.isEmpty()) {
            delMobileList = Lists.newArrayList();
            for (List<WeworkContactMobile> it4 : existsMobileMap.values()) {
                delMobileList.addAll(it4);
            }
        }
        Long operatorId = -1L;
        if (StringUtils.isNotBlank((CharSequence)userId) && (user = this.userMapper.selectUserByWeworkUserIdAndCorpId(userId, corpId)) != null) {
            operatorId = user.getId();
        }
        List<String> tagIds = null;
        if (CollectionUtils.isNotEmpty(addTagList)) {
            tagIds = addTagList.stream().map(WeworkContactTag::getTagId).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(addContactList)) {
            log.info("save contact:{}", (Object)addContactList.size());
            WeworkContact weworkContact = (WeworkContact)addContactList.get(0);
            if (isAdd && StringUtils.isNotBlank((CharSequence)mobile)) {
                weworkContact.setMobile(mobile);
            }
            this.weworkContactMapper.batchInsert(addContactList);
            ReplyContext replyContext = ReplyContextUtil.get();
            String weworkUserNum = replyContext.getWeworkUserNum();
            for (WeworkContact weworkContact2 : addContactList) {
                String channelNum = SysChannelEnum.QY_WEIXIN.getCode();
                log.info("add contact isAdd:{}; weworkUserNum:{};mobile:{}", new Object[]{isAdd, weworkUserNum, mobile});
                if (StringUtils.isNotBlank((CharSequence)weworkUserNum) && isAdd) {
                    TelAddFriendTask telAddFriendTask;
                    List telAddFriendTaskDetails = this.telAddFriendTaskDetailMapper.selectByCorpIdWeworkUserNumAndTel(corpId, weworkUserNum, mobile);
                    ArrayList needFilterStatus = Lists.newArrayList((Object[])new Integer[]{TelAddFriendStatus.SUCCESS.getStatus(), TelAddFriendStatus.EXPIRE.getStatus()});
                    List realTaskDetail = telAddFriendTaskDetails.stream().filter(item -> !needFilterStatus.contains(item.getStatus())).map(TelAddFriendTaskDetail::getTaskNum).collect(Collectors.toList());
                    log.info("realTaskDetail:{}", (Object)JSON.toJSONString(realTaskDetail));
                    if (CollectionUtils.isNotEmpty(realTaskDetail) && Objects.isNull(telAddFriendTask = this.telAddFriendTaskMapper.selectByNum((String)realTaskDetail.get(0))) && StringUtils.isNotBlank((CharSequence)telAddFriendTask.getChannelNums())) {
                        channelNum = telAddFriendTask.getChannelNums();
                    }
                }
                weworkContact2.setChannelNum(channelNum);
                Long channelId = null;
                if (StringUtils.isNotBlank((CharSequence)channelNum)) {
                    channelId = this.channelMapper.querySysChannelId(channelNum);
                }
                this.customerCenterService.pushContactCustomer(weworkContact2);
                if (!StringUtils.isNotEmpty((CharSequence)weworkContact2.getMobile())) continue;
                String moduleType = ModuleType.BATCH_ADD_FRIEND.getCode();
                this.customerCenterService.pushAddMobileEvent(weworkContact2.getBizId(), weworkContact2.getMobile(), moduleType);
                this.customerCenterService.pushMobileCustomer(weworkContact2.getBizId(), weworkContact2.getMobile(), weworkContact2.getName(), tagIds, operatorId, channelId);
                if (!this.checkMobileBindCustomer(bizId, weworkContact2.getMobile())) {
                    this.customerCenterService.bindCustomer(weworkContact2.getBizId(), weworkContact2.getCorpId(), weworkContact2.getContactId(), weworkContact2.getMobile(), moduleType);
                    continue;
                }
                log.info("save contact bind customer mobile:{} has bind contact", (Object)weworkContact2.getMobile());
            }
        }
        if (CollectionUtils.isNotEmpty(addRelationList)) {
            log.info("save contact relation:{}", (Object)addRelationList.size());
            this.weworkContactRelationMapper.batchInsert(addRelationList);
            for (WeworkContactRelation weworkContactRelation : addRelationList) {
                this.customerCenterService.pushContactRelation(weworkContactRelation);
            }
        }
        if (CollectionUtils.isNotEmpty(addTagList)) {
            log.info("save contact tag:{}", (Object)addTagList.size());
            this.weworkContactTagMapper.batchInsert(addTagList);
        }
        if (CollectionUtils.isNotEmpty(addMobileList)) {
            log.info("save contact mobile:{}", (Object)addMobileList.size());
            this.weworkContactMobileMapper.batchInsert(addMobileList);
        }
        this.initContactStage(bizId, corpId, userId, externalUserId);
        if (CollectionUtils.isNotEmpty((Collection)delTagList)) {
            Set ids = delTagList.stream().map(it -> it.getId()).collect(Collectors.toSet());
            log.info("delete contact tag size:{}, ids:{}", (Object)ids.size(), ids);
            this.weworkContactTagMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, followUser.getUserId());
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, externalUserId);
        String customerNum = weworkContact.getCustomerNum();
        if (StringUtils.isEmpty((CharSequence)customerNum)) {
            this.customerCenterService.pushContactCustomer(weworkContact);
            customerNum = weworkContact.getCustomerNum();
        }
        List addTagIds = null;
        if (CollectionUtils.isNotEmpty(addTagList)) {
            addTagIds = addTagList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTagId())).map(it -> it.getTagId()).collect(Collectors.toList());
        }
        Object var31_36 = null;
        if (CollectionUtils.isNotEmpty((Collection)delTagList)) {
            List list = delTagList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTagId())).map(it -> it.getTagId()).collect(Collectors.toList());
        }
        this.customerCenterService.pushTagRelation(bizId, weworkUserNum, customerNum, addTagIds, (List)var31_38);
        if (CollectionUtils.isNotEmpty((Collection)delMobileList)) {
            Set ids = delMobileList.stream().map(it -> it.getId()).collect(Collectors.toSet());
            log.info("delete contact mobile size:{}, ids:{}", (Object)ids.size(), ids);
            this.weworkContactMobileMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
        }
        if (CollectionUtils.isNotEmpty((Collection)followUser.getRemarkMobiles())) {
            CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum);
            log.info("query customer detail mobile1 : {}, mobile2: {}", (Object)detailResp.getMobile1(), (Object)detailResp.getMobile2());
            if (StringUtils.isNotBlank((CharSequence)detailResp.getMobile1()) && StringUtils.isNotBlank((CharSequence)detailResp.getMobile2())) {
                log.info("query customer detail has two mobile, no need update");
                return;
            }
            String mobile1 = "";
            String mobile2 = "";
            if (StringUtils.isNotBlank((CharSequence)detailResp.getMobile1()) && StringUtils.isBlank((CharSequence)detailResp.getMobile2())) {
                String followMobile;
                mobile1 = detailResp.getMobile1();
                if (mobile1.equals(followMobile = (String)followUser.getRemarkMobiles().get(0))) {
                    if (followUser.getRemarkMobiles().size() > 1) {
                        mobile2 = (String)followUser.getRemarkMobiles().get(1);
                    }
                } else {
                    mobile2 = followMobile;
                }
            }
            if (StringUtils.isBlank((CharSequence)detailResp.getMobile1()) && StringUtils.isBlank((CharSequence)detailResp.getMobile2())) {
                mobile1 = (String)followUser.getRemarkMobiles().get(0);
                if (followUser.getRemarkMobiles().size() > 1) {
                    mobile2 = (String)followUser.getRemarkMobiles().get(1);
                }
            }
            this.modMobileToCustomer(bizId, customerNum, mobile1, mobile2);
            List<String> delMobiles = delMobileList.stream().map(WeworkContactMobile::getRemarkMobile).collect(Collectors.toList());
            Long sysUserId = this.userMapper.getUserIdByWeworkUserId(bizId, followUser.getUserId());
            this.markCrmLeads(bizId, mobile1, mobile2, delMobiles, contact.getName(), tagIds, sysUserId, contact.getExternalUserId());
        }
    }

    private void modMobileToCustomer(Long bizId, String customerNum, String mobile1, String mobile2) {
        log.info("modMobileToCustomer bizId:{}, customerNum: {}, mobile1: {}, mobile2: {}", new Object[]{bizId, customerNum, mobile1, mobile2});
        ModMobileReq req = new ModMobileReq();
        req.setBizId(bizId);
        if (StringUtils.isNotBlank((CharSequence)mobile1)) {
            req.setMobile1(mobile1);
        }
        if (StringUtils.isNotBlank((CharSequence)mobile2)) {
            req.setMobile2(mobile2);
        }
        req.setCustomerNum(customerNum);
        req.setModuleType(ModuleType.REMARK_MOBILE.getCode());
        req.setSource("scrm");
        this.ccCustomerInfoService.modCustomerMobiles(req);
    }

    private boolean checkMobileBindCustomer(Long bizId, String mobile) {
        log.info("checkMobileBindCustomer bizId: {}, mobile: {}", (Object)bizId, (Object)mobile);
        boolean ret = false;
        String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, mobile);
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            log.info("checkMobileBindCustomer customerNum is empty");
            return false;
        }
        String contactId = this.ccCustomerNumService.getWeworkContactId(bizId, customerNum);
        log.info("checkMobileBindCustomer contactId: {}, customerNum: {}", (Object)contactId, (Object)customerNum);
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            ret = true;
        }
        return ret;
    }

    private void markCrmLeads(Long bizId, String mobile, String mobile1, List<String> delMobiles, String name, List<String> tagIds, Long userId, String contactId) {
        BizSimpleDto biz = this.scrmBizService.getById(bizId);
        if (biz.getIsOpenCrm() != 0) {
            HashSet<String> newMobiles = new HashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)mobile)) {
                newMobiles.add(mobile);
            }
            if (StringUtils.isNotBlank((CharSequence)mobile1)) {
                newMobiles.add(mobile1);
            }
            String corpId = biz.getCorpId();
            if (CollectionUtils.isNotEmpty(newMobiles)) {
                this.checkCrmLeads(corpId, newMobiles);
                CrmLeadsInfoResp resp = null;
                for (String m : newMobiles) {
                    CrmLeadsInfoReq req = new CrmLeadsInfoReq();
                    req.setCorpId(corpId);
                    req.setMobile(m);
                    resp = this.crmLeadsService.getLeads(req);
                    if (resp == null) continue;
                    break;
                }
                if (resp != null) {
                    this.modCrmLeadsMobile(corpId, resp.getNum(), mobile, mobile1);
                    return;
                }
                if (CollectionUtils.isNotEmpty(delMobiles)) {
                    String delMobile = (String)delMobiles.stream().findFirst().get();
                    CrmLeadsInfoReq req = new CrmLeadsInfoReq();
                    req.setCorpId(corpId);
                    req.setMobile(delMobile);
                    resp = this.crmLeadsService.getLeads(req);
                    if (resp != null) {
                        this.modCrmLeadsMobile(corpId, resp.getNum(), mobile, mobile1);
                        return;
                    }
                }
                this.addCrmLeads(bizId, corpId, mobile, mobile1, name, tagIds, userId, contactId);
            }
        }
    }

    private void checkCrmLeads(String corpId, Set<String> newMobiles) {
        if (newMobiles.size() <= 1) {
            return;
        }
        HashSet leadsNum = Sets.newHashSet();
        for (String mobile : newMobiles) {
            CrmLeadsInfoReq req = new CrmLeadsInfoReq();
            req.setCorpId(corpId);
            req.setMobile(mobile);
            CrmLeadsInfoResp resp = this.crmLeadsService.getLeads(req);
            if (resp == null) continue;
            leadsNum.add(resp.getNum());
        }
        Preconditions.checkArgument((leadsNum.size() <= 1 ? 1 : 0) != 0, (Object)"\u624b\u673a\u53f7\u5bf9\u5e94\u591a\u4e2a\u7ebf\u7d22\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u5230\u4e00\u4e2a\u5fae\u4fe1\u5ba2\u6237\u3002");
    }

    private void addCrmLeads(Long bizId, String corpId, String mobile, String mobile1, String name, List<String> tagIds, Long userId, String contactId) {
        log.info("add crm leads, corpId:{}, mobile:{}, mobile1:{}, name: {}, tagIds: {}", new Object[]{corpId, mobile, mobile1, name, tagIds});
        CustomerDetailResp customerDetail = this.ccCustomerNumService.getCustomerDetailByType(bizId, contactId);
        Long channelId = null;
        if (customerDetail != null && customerDetail.getChannelId() != null) {
            channelId = this.channelMapper.getIdByNum(bizId, customerDetail.getChannelId());
        }
        if (channelId == null) {
            channelId = this.channelMapper.querySysChannelId(SysChannelEnum.QY_WEIXIN.getCode());
        }
        CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
        crmLeadsReq.setCorpId(corpId);
        crmLeadsReq.setMobile(mobile);
        crmLeadsReq.setMobile1(mobile1);
        crmLeadsReq.setName(name);
        crmLeadsReq.setTagIds(tagIds);
        crmLeadsReq.setCreatorId(LoginUtils.getCurrentUserId());
        crmLeadsReq.setSourceType(Integer.valueOf(SourceType.SCRM_SYNC.getValue()));
        crmLeadsReq.setChannelId(channelId);
        crmLeadsReq.setAllocUserId(userId);
        this.crmLeadsService.addLeads(crmLeadsReq);
    }

    private void modCrmLeadsMobile(String corpId, String leadsNum, String mobile, String mobile1) {
        log.info("mod crm leads mobile, corpId:{}, leadsNum:{}, mobile1:{}, mobile2:{}", new Object[]{corpId, leadsNum, mobile, mobile1});
        CrmModMobileReq req = new CrmModMobileReq();
        req.setCorpId(corpId);
        req.setLeadsNum(leadsNum);
        req.setMobile(mobile);
        req.setMobile1(mobile1);
        this.crmLeadsService.modMobiles(req);
    }

    @Override
    public void delExternalContact(String corpId, String userId, String externalUserId, Long timestamp) {
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        WeworkContactRelation exist = this.weworkContactRelationMapper.get(corpId, userId, externalUserId);
        if (exist == null) {
            log.warn("wework contact relation not exist, corpId:{}, weworkUserId:{}, contactId:{}", new Object[]{corpId, userId, externalUserId});
            return;
        }
        Date deletedTime = new Date(timestamp * 1000L);
        WeworkContactRelation record = new WeworkContactRelation();
        record.setId(exist.getId());
        record.setIsDeleted(Integer.valueOf(1));
        record.setUpdateBy(Long.valueOf(-1L));
        record.setDeletedTime(deletedTime);
        record.setUpdateTime(new Date());
        this.weworkContactRelationMapper.updateByPrimaryKeySelective((Object)record);
        exist.setIsDeleted(Integer.valueOf(1));
        exist.setDeletedTime(deletedTime);
        this.customerCenterService.pushContactRelation(exist);
    }

    @Override
    public void delFollowUser(String corpId, String userId, String externalUserId, Long timestamp) {
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        WeworkContactRelation exist = this.weworkContactRelationMapper.get(corpId, userId, externalUserId);
        if (exist == null) {
            log.warn("wework contact relation not exist, corpId:{}, weworkUserId:{}, contactId:{}", new Object[]{corpId, userId, externalUserId});
            return;
        }
        WeworkContactRelation record = new WeworkContactRelation();
        record.setId(exist.getId());
        record.setIsZombieFans(Integer.valueOf(1));
        record.setUpdateBy(Long.valueOf(-1L));
        record.setUpdateTime(new Date());
        this.weworkContactRelationMapper.updateByPrimaryKeySelective((Object)record);
    }
}

