/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.wework.sdk.api.external.ExternalChatApi;
import cn.kinyun.wework.sdk.entity.external.groupchat.ChatDetailInfo;
import cn.kinyun.wework.sdk.entity.external.groupchat.ChatMember;
import cn.kinyun.wework.sdk.entity.external.groupchat.ChatSimpleInfo;
import cn.kinyun.wework.sdk.entity.external.groupchat.ExternalGroupChatListResp;
import cn.kinyun.wework.sdk.enums.ChatStatusFilter;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoomRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.synctask.service.ExternalChatSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExternalChatSyncServiceImpl
implements ExternalChatSyncService {
    private static final Logger log = LoggerFactory.getLogger(ExternalChatSyncServiceImpl.class);
    @Value(value="${default-chat-name:\u7fa4\u804a}")
    private String defaultChatName;
    @Autowired
    @Qualifier(value="synctaskThreadPool")
    private ExecutorService executorService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ExternalChatApi externalChatApi;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Integer devStatus = this.customizedTokenService.getAuthStatus(bizId);
        if (devStatus == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        if (devStatus.intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210");
        }
        return this.syncTaskService.start(bizId, corpId, SyncTaskType.EXTERNAL_CHAT, operatorId);
    }

    @Override
    public void fetch(String corpId) {
        log.info("fetch external chat, corpId:{}", (Object)corpId);
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        List userIds = this.weworkUserMapper.getWeworkUserIds(corpId);
        log.info("user ids:{}", (Object)userIds);
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (accessToken == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5065\u5e94\u7528");
        }
        List<ChatSimpleInfo> fetchSimpleList = this.fetchAllChatSimpleList(corpId, userIds, accessToken);
        log.info("external chat count:{}", (Object)fetchSimpleList.size());
        if (CollectionUtils.isEmpty(fetchSimpleList)) {
            log.info("external chat is empty, corpId:{}", (Object)corpId);
            return;
        }
        List pages = Lists.partition(fetchSimpleList, (int)100);
        for (List page : pages) {
            this.batchSaveChatRoom(bizId, corpId, page, accessToken);
        }
    }

    private List<ChatSimpleInfo> fetchAllChatSimpleList(final String corpId, List<String> userIds, final String accessToken) {
        final ArrayList fetchSimpleList = Lists.newArrayList();
        final ArrayList exceptions = Lists.newArrayList();
        final HashSet chatIds = Sets.newHashSet();
        ArrayList fetchTasks = Lists.newArrayList();
        for (final String userId : userIds) {
            Callable<Void> task = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    try {
                        List list = ExternalChatSyncServiceImpl.this.fetchChatSimpleList(corpId, userId, accessToken);
                        List list2 = fetchSimpleList;
                        synchronized (list2) {
                            for (ChatSimpleInfo chat : list) {
                                String chatId = chat.getChatId();
                                if (chatIds.contains(chatId)) {
                                    log.warn("duplicate chatId, corpId:{}, userId:{}, chatId:{}", new Object[]{corpId, userId, chatId});
                                    continue;
                                }
                                chatIds.add(chatId);
                                fetchSimpleList.add(chat);
                            }
                        }
                    }
                    catch (Exception e) {
                        List list = exceptions;
                        synchronized (list) {
                            exceptions.add(e);
                        }
                    }
                    return null;
                }
            };
            fetchTasks.add(task);
        }
        try {
            this.executorService.invokeAll(fetchTasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            log.error("invoke synctask failed", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c9\u53d6\u6570\u636e\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)exceptions)) {
            log.info("fetch external chat error:{}", (Object)exceptions.size());
            Exception e = (Exception)exceptions.get(0);
            if (e instanceof BusinessException) {
                throw (BusinessException)e;
            }
            if (e instanceof WeworkException) {
                throw (WeworkException)((Object)e);
            }
            throw new RuntimeException(e);
        }
        return fetchSimpleList;
    }

    private List<ChatDetailInfo> fetchAllChatDetailList(final String corpId, List<ChatSimpleInfo> fetchSimpleList, final String accessToken) {
        int capacity = fetchSimpleList.size();
        final ArrayList fetchDetailList = Lists.newArrayListWithCapacity((int)capacity);
        final ArrayList exceptions = Lists.newArrayListWithCapacity((int)capacity);
        ArrayList fetchTasks = Lists.newArrayListWithCapacity((int)capacity);
        for (final ChatSimpleInfo chat : fetchSimpleList) {
            Callable<Void> task = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    try {
                        ChatDetailInfo chatDetail = ExternalChatSyncServiceImpl.this.fetchChatDetail(corpId, chat.getChatId(), accessToken);
                        List list = fetchDetailList;
                        synchronized (list) {
                            fetchDetailList.add(chatDetail);
                        }
                    }
                    catch (Exception e) {
                        List list = exceptions;
                        synchronized (list) {
                            exceptions.add(e);
                        }
                    }
                    return null;
                }
            };
            fetchTasks.add(task);
        }
        try {
            this.executorService.invokeAll(fetchTasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            log.error("invoke synctask failed", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c9\u53d6\u6570\u636e\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)exceptions)) {
            log.info("fetch external chat detail error:{}", (Object)exceptions.size());
            Exception e = (Exception)exceptions.get(0);
            if (e instanceof BusinessException) {
                throw (BusinessException)e;
            }
            if (e instanceof WeworkException) {
                throw (WeworkException)((Object)e);
            }
            throw new RuntimeException(e);
        }
        return fetchDetailList;
    }

    private List<ChatSimpleInfo> fetchChatSimpleList(String corpId, String weworkUserId, String accessToken) {
        log.info("fetch chat simple list, corpId:{}, userId:{}", (Object)corpId, (Object)weworkUserId);
        ArrayList fetchList = Lists.newArrayList();
        List<String> owner = Collections.singletonList(weworkUserId);
        String cursor = null;
        Integer limit = 1000;
        do {
            try {
                ExternalGroupChatListResp resp = this.externalChatApi.list(accessToken, ChatStatusFilter.ALL, owner, cursor, limit);
                log.info("external chat, userIds:{}, resp:{}", owner, (Object)resp);
                cursor = resp.getNextCursor();
                fetchList.addAll(resp.getGroupChatList());
            }
            catch (WeworkException e) {
                if (e.getErrorCode() == 60011) {
                    log.error("\u8be5\u6210\u5458\u6ca1\u6709\u914d\u7f6e\u5ba2\u6237\u8054\u7cfb\u6743\u9650, userIds:{}", owner);
                    continue;
                }
                log.error("{}, userIds:{}", (Object)e.getMessage(), owner);
                throw e;
            }
            catch (Exception e) {
                log.error("failed to get external chat, userIds:{}", owner, (Object)e);
                throw e;
            }
        } while (cursor != null);
        return fetchList;
    }

    private ChatDetailInfo fetchChatDetail(String corpId, String chatId, String accessToken) {
        log.info("fetch chat detail, corpId:{}, chatId:{}", (Object)corpId, (Object)chatId);
        try {
            ChatDetailInfo chatDetail = this.externalChatApi.detail(accessToken, chatId);
            log.info("fetch chatId:{}, detail:{}", (Object)chatId, (Object)chatDetail);
            if (StringUtils.isBlank((CharSequence)chatDetail.getName())) {
                String displayName = this.getDisplayName(corpId, chatDetail);
                chatDetail.setName(displayName);
            }
            return chatDetail;
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, chatId:{}", new Object[]{e.getMessage(), corpId, chatId, e});
            throw e;
        }
        catch (Exception e) {
            log.error("failed to get external chat, corpId:{}, chatId:{}", new Object[]{corpId, chatId, e});
            throw e;
        }
    }

    private void batchSaveChatRoom(Long bizId, String corpId, List<ChatSimpleInfo> fetchSimpleList, String accessToken) {
        List<ChatDetailInfo> fetchDetailList = this.fetchAllChatDetailList(corpId, fetchSimpleList, accessToken);
        Map<String, ChatDetailInfo> fetchDetailMap = fetchDetailList.stream().collect(Collectors.toMap(it -> it.getChatId(), it -> it));
        int capacity = fetchSimpleList.size();
        ArrayList addRoomList = Lists.newArrayListWithCapacity((int)capacity);
        ArrayList addRelationList = Lists.newArrayListWithCapacity((int)capacity);
        ArrayList delRelationList = Lists.newArrayList();
        Set chatRoomIds = fetchSimpleList.stream().map(it -> it.getChatId()).collect(Collectors.toSet());
        List existsRoomList = this.weworkChatRoomMapper.batchQueryChatRooms(corpId, chatRoomIds);
        Map<Object, Object> existsRoomMap = CollectionUtils.isNotEmpty((Collection)existsRoomList) ? existsRoomList.stream().collect(Collectors.toMap(it -> it.getWeworkRoomId(), it -> it)) : Collections.emptyMap();
        List existsRelationList = this.weworkChatRoomRelationMapper.batchQueryMembers(corpId, chatRoomIds);
        Map<Object, Object> existsRelationMap = CollectionUtils.isNotEmpty((Collection)existsRelationList) ? existsRelationList.stream().collect(Collectors.groupingBy(it -> it.getWeworkRoomId())) : Collections.emptyMap();
        for (ChatSimpleInfo chat : fetchSimpleList) {
            List existsRelation;
            ChatDetailInfo chatDetail = fetchDetailMap.get(chat.getChatId());
            if (chatDetail == null) continue;
            String chatId = chat.getChatId();
            WeworkChatRoom existsRoom = (WeworkChatRoom)existsRoomMap.remove(chatId);
            if (this.diffRoom(existsRoom, chat.getStatus(), chatDetail)) {
                addRoomList.add(this.newChatRoom(bizId, corpId, chat.getStatus(), chatDetail));
            }
            Map<Object, Object> existsMemberMap = CollectionUtils.isNotEmpty((Collection)(existsRelation = (List)existsRelationMap.remove(chatId))) ? existsRelation.stream().collect(Collectors.toMap(it -> it.getMemberId(), it -> it)) : Collections.emptyMap();
            addRelationList.addAll(this.newChatRoomRelationList(bizId, corpId, chatDetail, existsMemberMap));
            delRelationList.addAll(existsMemberMap.values());
        }
        if (CollectionUtils.isNotEmpty((Collection)addRoomList)) {
            log.info("save wework chat room, count:{}", (Object)addRoomList.size());
            Lists.partition((List)addRoomList, (int)200).forEach(rooms -> this.weworkChatRoomMapper.batchInsert(rooms));
        }
        if (CollectionUtils.isNotEmpty((Collection)addRelationList)) {
            log.info("save wework chat room member, count:{}", (Object)addRelationList.size());
            Lists.partition((List)addRelationList, (int)200).forEach(members -> this.weworkChatRoomRelationMapper.batchInsert(members));
        }
        this.deleteChatRoomRelation(delRelationList);
        this.deleteChatRoom(existsRoomMap.values());
    }

    private boolean diffRoom(WeworkChatRoom exist, Integer status, ChatDetailInfo detail) {
        if (exist == null) {
            return true;
        }
        if (!Objects.equal((Object)detail.getName(), (Object)exist.getName())) {
            return true;
        }
        if (!Objects.equal((Object)detail.getNotice(), (Object)exist.getNotice())) {
            return true;
        }
        if (!Objects.equal((Object)detail.getOwner(), (Object)exist.getOwner())) {
            return true;
        }
        return status != null && !Objects.equal((Object)status, (Object)exist.getStatus());
    }

    private WeworkChatRoom newChatRoom(Long bizId, String corpId, Integer status, ChatDetailInfo chatDetail) {
        Date now = new Date();
        String chatId = chatDetail.getChatId();
        String owner = chatDetail.getOwner();
        WeworkChatRoom record = new WeworkChatRoom();
        record.setNum(this.idGen.getNum());
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setWeworkRoomId(chatId);
        record.setOwner(owner);
        record.setName(chatDetail.getName());
        record.setNotice(chatDetail.getNotice());
        record.setStatus(status);
        record.setBuildRoomTime(new Date(chatDetail.getCreateTime() * 1000L));
        record.setCreateTime(now);
        record.setUpdateTime(now);
        return record;
    }

    private List<WeworkChatRoomRelation> newChatRoomRelationList(Long bizId, String corpId, ChatDetailInfo chatDetail, Map<String, WeworkChatRoomRelation> existsMemberMap) {
        String chatId = chatDetail.getChatId();
        String owner = chatDetail.getOwner();
        if (CollectionUtils.isEmpty((Collection)chatDetail.getMemberList())) {
            log.info("chat member list is empty, corpId:{}, chatId:{}", (Object)corpId, (Object)chatId);
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        Set<String> adminSet = CollectionUtils.isNotEmpty((Collection)chatDetail.getAdminList()) ? chatDetail.getAdminList().stream().map(it -> it.getUserId()).collect(Collectors.toSet()) : Collections.emptySet();
        for (ChatMember it2 : chatDetail.getMemberList()) {
            String memberId = it2.getUserId();
            WeworkChatRoomRelation exist = existsMemberMap.remove(memberId);
            if (!this.diffMember(exist, owner, adminSet, it2)) continue;
            list.add(this.newChatRoomRelation(bizId, corpId, chatId, owner, adminSet, it2));
        }
        return list;
    }

    private boolean diffMember(WeworkChatRoomRelation exist, String owner, Set<String> adminSet, ChatMember member) {
        if (exist == null) {
            return true;
        }
        if (!Objects.equal((Object)member.getName(), (Object)exist.getName())) {
            return true;
        }
        if (!Objects.equal((Object)member.getGroupNickname(), (Object)exist.getGroupNickname())) {
            return true;
        }
        if (!Objects.equal((Object)member.getType(), (Object)exist.getType())) {
            return true;
        }
        if (!Objects.equal((Object)member.getJoinScene(), (Object)exist.getJoinScene())) {
            return true;
        }
        Long joinTime = null;
        if (exist.getJoinTime() != null) {
            joinTime = exist.getJoinTime().getTime() / 1000L;
        }
        if (!Objects.equal((Object)member.getJoinTime(), joinTime)) {
            return true;
        }
        String invitor = null;
        if (member.getInvitor() != null) {
            invitor = member.getInvitor().getUserId();
        }
        if (!Objects.equal((Object)invitor, (Object)exist.getInvitor())) {
            return true;
        }
        String memberId = member.getUserId();
        Integer isOwner = owner.equals(memberId) ? 1 : 0;
        if (!Objects.equal((Object)isOwner, (Object)exist.getIsOwner())) {
            return true;
        }
        Integer isAdmin = adminSet.contains(memberId) ? 1 : 0;
        return !Objects.equal((Object)isAdmin, (Object)exist.getIsOwner());
    }

    private WeworkChatRoomRelation newChatRoomRelation(Long bizId, String corpId, String chatId, String owner, Set<String> adminSet, ChatMember member) {
        String memberId = member.getUserId();
        WeworkChatRoomRelation record = new WeworkChatRoomRelation();
        record.setNum(this.idGen.getNum());
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setWeworkRoomId(chatId);
        record.setMemberId(memberId);
        record.setName(member.getName());
        record.setGroupNickname(member.getGroupNickname());
        record.setType(member.getType());
        record.setJoinScene(member.getJoinScene());
        if (member.getJoinTime() != null) {
            record.setJoinTime(new Date(member.getJoinTime() * 1000L));
        }
        if (member.getInvitor() != null) {
            record.setInvitor(member.getInvitor().getUserId());
        }
        record.setIsOwner(Integer.valueOf(owner.equals(memberId) ? 1 : 0));
        record.setIsAdmin(Integer.valueOf(adminSet.contains(memberId) ? 1 : 0));
        Date now = new Date();
        record.setCreateTime(now);
        record.setUpdateTime(now);
        return record;
    }

    private void deleteChatRoom(Collection<WeworkChatRoom> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Set ids = list.stream().map(it -> it.getId()).collect(Collectors.toSet());
            log.info("delete chat room, ids:{}", ids);
            this.weworkChatRoomMapper.logicDeleteByIds(ids);
        }
    }

    private void deleteChatRoomRelation(Collection<WeworkChatRoomRelation> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Set ids = list.stream().map(it -> it.getId()).collect(Collectors.toSet());
            log.info("delete chat room relation, ids:{}", ids);
            this.weworkChatRoomRelationMapper.logicDeleteByIds(ids);
        }
    }

    private void deleteChatRoomRelation(Collection<WeworkChatRoomRelation> list, Integer quitScene) {
        if (CollectionUtils.isNotEmpty(list)) {
            Set ids = list.stream().map(it -> it.getId()).collect(Collectors.toSet());
            log.info("delete chat room relation, ids:{}", ids);
            this.weworkChatRoomRelationMapper.logicDeleteByIds(ids);
        }
    }

    @Override
    public void create(String accessToken, String corpId, String chatId) {
        List existsRelation;
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        ChatDetailInfo chatDetail = this.fetchChatDetail(corpId, chatId, accessToken);
        WeworkChatRoom existsRoom = this.weworkChatRoomMapper.getWeworkChatRoom(corpId, chatId);
        List<Object> addRoomList = Collections.emptyList();
        if (this.diffRoom(existsRoom, null, chatDetail)) {
            addRoomList = Collections.singletonList(this.newChatRoom(bizId, corpId, null, chatDetail));
        }
        Map<String, WeworkChatRoomRelation> existsMemberMap = CollectionUtils.isNotEmpty((Collection)(existsRelation = this.weworkChatRoomRelationMapper.queryRoomMembers(corpId, chatId))) ? existsRelation.stream().collect(Collectors.toMap(it -> it.getMemberId(), it -> it)) : Collections.emptyMap();
        List<WeworkChatRoomRelation> addRelationList = this.newChatRoomRelationList(bizId, corpId, chatDetail, existsMemberMap);
        if (CollectionUtils.isNotEmpty(addRoomList)) {
            log.info("save wework chat room, count:{}", (Object)addRoomList.size());
            this.weworkChatRoomMapper.batchInsert(addRoomList);
        }
        if (CollectionUtils.isNotEmpty(addRelationList)) {
            log.info("save wework chat room member, count:{}", (Object)addRelationList.size());
            this.weworkChatRoomRelationMapper.batchInsert(addRelationList);
        }
        this.deleteChatRoomRelation(existsMemberMap.values());
    }

    @Override
    public void modify(String accessToken, String corpId, String chatId, Integer quitScene) {
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        ChatDetailInfo chatDetail = this.fetchChatDetail(corpId, chatId, accessToken);
        WeworkChatRoom existsRoom = this.weworkChatRoomMapper.getWeworkChatRoom(corpId, chatId);
        List<Object> addRoomList = Collections.emptyList();
        if (this.diffRoom(existsRoom, null, chatDetail)) {
            addRoomList = Collections.singletonList(this.newChatRoom(bizId, corpId, null, chatDetail));
        }
        ReplyContext ctx = ReplyContextUtil.get();
        Set<Object> existMemberIds = Sets.newHashSet();
        Set newMemberIds = Sets.newHashSet();
        List existsRelation = this.weworkChatRoomRelationMapper.queryRoomMembers(corpId, chatId);
        Map<Object, Object> existsMemberMap = CollectionUtils.isNotEmpty((Collection)existsRelation) ? existsRelation.stream().collect(Collectors.toMap(it -> it.getMemberId(), it -> it)) : Collections.emptyMap();
        existMemberIds = existsMemberMap.keySet();
        List<WeworkChatRoomRelation> addRelationList = this.newChatRoomRelationList(bizId, corpId, chatDetail, existsMemberMap);
        if (CollectionUtils.isNotEmpty(addRoomList)) {
            log.info("save wework chat room, count:{}", (Object)addRoomList.size());
            this.weworkChatRoomMapper.batchInsert(addRoomList);
        }
        if (CollectionUtils.isNotEmpty(addRelationList)) {
            log.info("save wework chat room member, count:{}", (Object)addRelationList.size());
            this.weworkChatRoomRelationMapper.batchInsert(addRelationList);
        }
        if (quitScene == null) {
            this.deleteChatRoomRelation(existsMemberMap.values());
        } else {
            this.deleteChatRoomRelation(existsMemberMap.values(), quitScene);
        }
        newMemberIds = this.weworkChatRoomRelationMapper.queryRoomMemberIds(corpId, chatId);
        ctx.setExistMemberIds((Set)existMemberIds);
        ctx.setNewMemberIds(newMemberIds);
    }

    @Override
    public void dismiss(String corpId, String chatId) {
        log.info("dismiss wework_chat_room, corpId:{}, chatId:{}", (Object)corpId, (Object)chatId);
        WeworkChatRoom exist = this.weworkChatRoomMapper.getWeworkChatRoom(corpId, chatId);
        if (exist == null) {
            log.info("wework_chat_room not found");
            return;
        }
        if (exist.getIsDismiss() != null && exist.getIsDismiss() == 1) {
            return;
        }
        WeworkChatRoom record = new WeworkChatRoom();
        record.setId(exist.getId());
        record.setIsDismiss(Integer.valueOf(1));
        record.setUpdateTime(new Date());
        this.weworkChatRoomMapper.updateByPrimaryKeySelective((Object)record);
    }

    private String getDisplayName(String corpId, ChatDetailInfo chatDetail) {
        String name;
        List memberList = chatDetail.getMemberList();
        log.info("get display name, corpId:{}, memberList:{}", (Object)corpId, (Object)memberList);
        if (CollectionUtils.isEmpty((Collection)memberList) || memberList.size() <= 1) {
            log.info("\u53ea\u6709\u4e00\u4e2a\u7fa4\u6210\u5458\uff0c\u53ef\u80fd\u662f\u521a\u5efa\u7fa4\u7684\u72b6\u6001\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7684\u7fa4\u540d\u3002");
            return this.defaultChatName;
        }
        StringBuilder sb = new StringBuilder();
        String seperator = "\u3001";
        int size = memberList.size();
        for (int i = 0; i < size; ++i) {
            ChatMember member = (ChatMember)memberList.get(i);
            String name2 = member.getName();
            if (StringUtils.isBlank((CharSequence)name2)) continue;
            sb.append(name2);
            if (i >= size - 1) continue;
            sb.append(seperator);
        }
        String displayName = sb.toString();
        if (StringUtils.isBlank((CharSequence)displayName)) {
            log.info("\u7fa4\u540d\u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7fa4\u540d\u3002");
            return this.defaultChatName;
        }
        Integer maxDisplayNameLength = 20;
        String replaceEmojiStr = displayName.replaceAll("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]", "");
        int characterLength = replaceEmojiStr.length();
        int emojiLength = (displayName.length() - characterLength) / 2;
        int totalLength = emojiLength + characterLength;
        if (totalLength > maxDisplayNameLength) {
            int offset = displayName.offsetByCodePoints(0, maxDisplayNameLength - 3);
            name = displayName.substring(0, offset) + "...";
        } else {
            name = displayName;
        }
        log.info("\u6700\u7ec8\u751f\u6210\u7fa4\u540d:{}", (Object)name);
        return name;
    }
}

