/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.wework.sdk.api.AgentApi;
import cn.kinyun.wework.sdk.api.CustomizedApi;
import cn.kinyun.wework.sdk.api.DepartmentApi;
import cn.kinyun.wework.sdk.api.UserApi;
import cn.kinyun.wework.sdk.entity.agent.Agent;
import cn.kinyun.wework.sdk.entity.agent.AllowUser;
import cn.kinyun.wework.sdk.entity.agent.AllowUserInfos;
import cn.kinyun.wework.sdk.entity.contact.department.Department;
import cn.kinyun.wework.sdk.entity.contact.user.UserInfo;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.enums.WeworkCorpSyncStatus;
import com.kuaike.scrm.common.enums.WeworkUserSyncStatus;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.addFriend.mapper.AddFriendConfigMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.chat.mapper.WeworkConversationMapper;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkGroupMsgResultMapper;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkGroupMsgTaskMapper;
import com.kuaike.scrm.dal.permission.dto.UserDiffNodeDto;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartment;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartmentUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.synctask.service.ContactSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import com.kuaike.scrm.token.service.SuiteTokenService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContactSyncServiceImpl
implements ContactSyncService {
    private static final Logger log = LoggerFactory.getLogger(ContactSyncServiceImpl.class);
    private static final int ROOT_DEPT = 1;
    private static final Pattern VCODE_REGEX = Pattern.compile("vcode=([a-z0-9]+)");
    @Autowired
    private IdGen idGen;
    @Autowired
    private AgentApi agentApi;
    @Autowired
    private UserApi userApi;
    @Autowired
    private DepartmentApi departmentApi;
    @Autowired
    private CustomizedApi customizedApi;
    @Autowired
    private SuiteTokenService suiteTokenService;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkDepartmentMapper weworkDepartmentMapper;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private WeworkGroupMsgResultMapper weworkGroupMsgResultMapper;
    @Autowired
    private WeworkGroupMsgTaskMapper weworkGroupMsgTaskMapper;
    @Autowired
    private WeworkConversationMapper weworkConversationMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private AddFriendConfigMapper addFriendConfigMapper;

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Integer devStatus = this.customizedTokenService.getAuthStatus(bizId);
        if (devStatus == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        if (devStatus.intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210");
        }
        Long taskId = this.syncTaskService.start(bizId, corpId, SyncTaskType.CONTACT, operatorId);
        this.syncTaskService.start(bizId, corpId, SyncTaskType.CUSTOMIZED_APP, operatorId);
        return taskId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void fetch(String corpId) {
        List fetchDeptList;
        log.info("fetch department, corpId:{}", (Object)corpId);
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        log.info("get department list, corpId:{}", (Object)corpId);
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId:{}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        Boolean useSuiteToken = false;
        ArrayList fetchUserList = Lists.newArrayList();
        HashSet fetchUserIds = Sets.newHashSet();
        try {
            fetchDeptList = this.departmentApi.list(accessToken, null);
            log.info("Fetch department list:{}", (Object)fetchDeptList);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", (Object)e.getMessage(), (Object)corpId);
            throw e;
        }
        catch (Exception e) {
            log.error("Fetch department list failed.", (Throwable)e);
            throw e;
        }
        this.fetchDeptUser(corpId, fetchDeptList, fetchUserList, fetchUserIds);
        this.fetchAgentUser(corpId, fetchUserList, fetchUserIds);
        this.saveWeworkDepartment(bizId, corpId, fetchDeptList, useSuiteToken);
        this.saveOrganization(bizId, corpId, useSuiteToken);
        Map<String, String> openUserIdMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)fetchUserList)) {
            List<String> userIds = fetchUserList.stream().map(UserInfo::getUserId).collect(Collectors.toList());
            openUserIdMap = this.fetchOpenUserIds(corpId, userIds);
        }
        fetchUserList.sort(Comparator.comparing(UserInfo::getUserId));
        this.saveWeworkUser(bizId, corpId, fetchUserList, openUserIdMap);
        this.saveDepartmentUser(bizId, corpId, fetchUserList);
        this.fixNodeIds(corpId, null);
    }

    private void fetchDeptUser(String corpId, List<Department> fetchDeptList, List<UserInfo> fetchUserList, Set<String> fetchUserIds) {
        if (CollectionUtils.isEmpty(fetchDeptList)) {
            log.info("\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u7684\u53ef\u89c1\u8303\u56f4\u4e0b\uff0c\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u90e8\u95e8\u3002corpId:{}", (Object)corpId);
            return;
        }
        List deptIds = fetchDeptList.stream().map(Department::getId).collect(Collectors.toList());
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId:{}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        for (Integer deptId : deptIds) {
            List<UserInfo> list;
            try {
                list = this.userApi.list(accessToken, deptId, Integer.valueOf(0));
                if (list == null) {
                    list = Collections.emptyList();
                }
                log.info("fetch user list, deptId:{}, count:{}", (Object)deptId, (Object)list.size());
            }
            catch (WeworkException e) {
                log.error("{}, deptId:{}", (Object)e.getMessage(), (Object)deptId);
                throw e;
            }
            catch (Exception e) {
                log.error("fetch user list failed, deptId:{}", (Object)deptId, (Object)e);
                throw e;
            }
            for (UserInfo u : list) {
                if (fetchUserIds.contains(u.getUserId())) continue;
                this.addFakeUserDept(u);
                fetchUserIds.add(u.getUserId());
                fetchUserList.add(u);
            }
        }
    }

    private void fetchAgentUser(String corpId, List<UserInfo> fetchUserList, Set<String> fetchUserIds) {
        Agent agent;
        log.info("get customized agent user list, corpId:{}", (Object)corpId);
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId:{}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        Integer agentId = this.customizedTokenService.getAgentId(corpId);
        if (agentId == null) {
            log.warn("\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId:{}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        try {
            agent = this.agentApi.getAgent(accessToken, agentId);
            log.info("Fetch customized agent:{}", (Object)agent);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", (Object)e.getMessage(), (Object)corpId);
            throw e;
        }
        catch (Exception e) {
            log.error("Fetch customized agent failed.", (Throwable)e);
            throw e;
        }
        AllowUserInfos allowUserInfos = agent.getAllowUserInfos();
        if (allowUserInfos == null || CollectionUtils.isEmpty((Collection)allowUserInfos.getUserList())) {
            log.info("\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u7684\u53ef\u89c1\u8303\u56f4\u4e0b\u6ca1\u6709\u5355\u72ec\u52fe\u9009\u6210\u5458\u3002corpId={}", (Object)corpId);
            return;
        }
        List userIds = allowUserInfos.getUserList().stream().map(AllowUser::getUserId).collect(Collectors.toList());
        for (String userId : userIds) {
            UserInfo u;
            if (fetchUserIds.contains(userId)) continue;
            try {
                u = this.userApi.get(accessToken, userId);
                log.info("fetch user info, userId:{}, name:{}", (Object)userId, (Object)u.getName());
            }
            catch (WeworkException e) {
                log.error("{}, userId:{}", (Object)e.getMessage(), (Object)userId);
                throw e;
            }
            catch (Exception e) {
                log.error("fetch user info failed, userId:{}", (Object)userId, (Object)e);
                throw e;
            }
            this.addFakeUserDept(u);
            fetchUserIds.add(u.getUserId());
            fetchUserList.add(u);
        }
    }

    private Map<String, String> fetchOpenUserIds(String corpId, List<String> userIds) {
        log.info("get customized open userIds, corpId:{}", (Object)corpId);
        if (CollectionUtils.isEmpty(userIds)) {
            log.info("user list is empty.");
            return Collections.emptyMap();
        }
        if (corpId.startsWith("wp")) {
            log.info("2022\u5e746\u670820\u65e5\u540e\u6388\u6743\u7684\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\uff0c\u4e0d\u67e5\u8be2\u5bc6\u6587userId\u3002corpId={}", (Object)corpId);
            return userIds.stream().collect(Collectors.toMap(it -> it, it -> it));
        }
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId:{}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        List userIdList = Lists.partition(userIds, (int)200);
        for (List pageUserIds : userIdList) {
            try {
                Map pageMap = this.customizedApi.getOpenUserIdMap(accessToken, pageUserIds);
                map.putAll(pageMap);
            }
            catch (WeworkException e) {
                log.error("{}, userIds:{}", (Object)e.getMessage(), userIds);
                throw e;
            }
            catch (Exception e) {
                log.error("fetch open userIds failed, userIds:{}", userIds, (Object)e);
                throw e;
            }
        }
        return map;
    }

    private void deleteDepartment(String corpId, Collection<Integer> deptIds) {
        if (CollectionUtils.isNotEmpty(deptIds)) {
            log.info("delete wework department, corpId:{}, deptIds:{}", (Object)corpId, deptIds);
            int ret = this.weworkDepartmentMapper.delDepartmentList(corpId, deptIds);
            if (ret > 0) {
                log.info("\u5220\u9664\u90e8\u95e8, modified:{}", (Object)ret);
            }
            if ((ret = this.weworkDepartmentUserMapper.delDepartmentUserByDept(corpId, deptIds)) > 0) {
                log.info("\u5220\u9664\u90e8\u95e8\u6210\u5458\u5173\u7cfb, modified:{}", (Object)ret);
            }
            if ((ret = this.organizationMapper.logicDeleteByDeptIds(corpId, deptIds)) > 0) {
                log.info("\u5220\u9664\u7ec4\u7ec7\u67b6\u6784, modified:{}", (Object)ret);
            }
        }
    }

    private void deleteUser(String corpId, Collection<String> weworkUserIds, boolean forceDeleteUser) {
        log.info("delete wework user, corpId:{}, weworkUserIds:{}, forceDeleteUser:{}", new Object[]{corpId, weworkUserIds, forceDeleteUser});
        if (CollectionUtils.isNotEmpty(weworkUserIds)) {
            List weworkUserNums = this.weworkUserMapper.getWeworkUserNumsByCorpIdAndWeworkUserIds(corpId, weworkUserIds);
            int ret = this.weworkUserMapper.delWeworkUsers(corpId, weworkUserIds);
            if (ret > 0) {
                log.info("\u5220\u9664\u6210\u5458, modified:{}", (Object)ret);
            }
            if ((ret = this.weworkDepartmentUserMapper.delDepartmentUserByUser(corpId, weworkUserIds)) > 0) {
                log.info("\u5220\u9664\u90e8\u95e8\u6210\u5458\u5173\u7cfb, modified:{}", (Object)ret);
            }
            if ((ret = this.weworkContactRelationMapper.delByWeworkUserIds(corpId, weworkUserIds)) > 0) {
                log.info("\u5220\u9664\u5ba2\u6237\u5173\u7cfb, modified:{}", (Object)ret);
            }
            if ((ret = this.weworkContactTagMapper.delByWeworkUserIds(corpId, weworkUserIds)) > 0) {
                log.info("\u5220\u9664\u5ba2\u6237\u6807\u7b7e, modified:{}", (Object)ret);
            }
            if ((ret = this.weworkContactMobileMapper.delByWeworkUserIds(corpId, weworkUserIds)) > 0) {
                log.info("\u5220\u9664\u5ba2\u6237\u5907\u6ce8\u624b\u673a\u53f7, modified:{}", (Object)ret);
            }
            if (forceDeleteUser) {
                ret = this.userMapper.delByWeworkUserIds(corpId, weworkUserIds);
                if (ret > 0) {
                    log.info("\u5220\u9664\u6210\u5458\u5173\u8054\u7684\u7528\u6237, modified:{}", (Object)ret);
                }
            } else {
                ret = this.userMapper.softDelByWeworkUserIds(corpId, weworkUserIds);
                if (ret > 0) {
                    log.info("\u67d4\u6027\u5220\u9664\u6210\u5458\u5173\u8054\u7684\u7528\u6237, modified:{}", (Object)ret);
                }
            }
            this.delAddFriendConfig(corpId, weworkUserNums);
        }
    }

    private void delAddFriendConfig(String corpId, Collection<String> weworkUserNums) {
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            return;
        }
        log.info("\u5373\u5c06\u6e05\u9664\u4e0b\u5217\u6210\u5458\u7684\u65b0\u597d\u53cb\u914d\u7f6e:{}", weworkUserNums);
        int ret = this.addFriendConfigMapper.delByWeworkUserNums(corpId, weworkUserNums);
        if (ret > 0) {
            log.info("\u5df2\u5220\u9664\u65b0\u597d\u53cb\u914d\u7f6e, modified:{}", (Object)ret);
        }
    }

    private void saveWeworkDepartment(Long bizId, String corpId, List<Department> list, Boolean useSuiteToken) {
        this.addFakeRootDept(list, corpId);
        List existsDeptList = this.weworkDepartmentMapper.getDepartmentList(corpId);
        Map<Object, Object> existsMap = CollectionUtils.isNotEmpty((Collection)existsDeptList) ? existsDeptList.stream().collect(Collectors.toMap(WeworkDepartment::getDepartmentId, it -> it)) : new HashMap();
        if (CollectionUtils.isEmpty(list)) {
            log.info("department list is empty, corpId: {}", (Object)corpId);
            this.deleteDepartment(corpId, existsMap.keySet());
            return;
        }
        ArrayList addList = Lists.newArrayList();
        for (Department dept : list) {
            WeworkDepartment exist = (WeworkDepartment)existsMap.remove(dept.getId());
            if (!this.diffDept(exist, dept, useSuiteToken)) continue;
            WeworkDepartment record = this.newDept(bizId, corpId, dept, useSuiteToken);
            addList.add(record);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            Lists.partition((List)addList, (int)200).forEach(depts -> this.weworkDepartmentMapper.batchInsert((Collection)depts));
        }
        this.deleteDepartment(corpId, existsMap.keySet());
    }

    private boolean diffDept(WeworkDepartment exist, Department dept, Boolean useSuiteToken) {
        if (exist == null) {
            log.info("department not exist, deptId:{}", (Object)dept.getId());
            return true;
        }
        if (!useSuiteToken.booleanValue() && !Objects.equals(dept.getName(), exist.getName())) {
            log.info("diff name, old:{}, new:{}", (Object)exist.getName(), (Object)dept.getName());
            return true;
        }
        if (!Objects.equals(dept.getParentId(), exist.getParentId())) {
            log.info("diff parentId, old:{}, new:{}", (Object)exist.getParentId(), (Object)dept.getParentId());
            return true;
        }
        if (!Objects.equals(dept.getOrder(), exist.getOrder())) {
            log.info("diff order, old:{}, new:{}", (Object)exist.getOrder(), (Object)dept.getOrder());
            return true;
        }
        return false;
    }

    private WeworkDepartment newDept(Long bizId, String corpId, Department dept, Boolean useSuiteToken) {
        WeworkDepartment record = new WeworkDepartment();
        record.setBizId(bizId);
        record.setCorpId(corpId);
        if (!useSuiteToken.booleanValue()) {
            record.setName(dept.getName());
            record.setNameEn(dept.getNameEn());
        }
        record.setDepartmentId(dept.getId());
        record.setOrder(dept.getOrder());
        record.setParentId(dept.getParentId());
        record.setNum(this.idGen.getNum());
        record.setCreateTime(new Date());
        record.setCreateBy(Long.valueOf(-1L));
        record.setUpdateTime(new Date());
        record.setUpdateBy(Long.valueOf(-1L));
        record.setIsDeleted(Integer.valueOf(0));
        return record;
    }

    private void saveOrganization(Long bizId, String corpId, Boolean useSuiteToken) {
        List deptList = this.weworkDepartmentMapper.getDepartmentList(corpId);
        List orgList = this.organizationMapper.selectByBizIdAndCorpId(bizId, corpId);
        Map<Integer, Organization> deptOrgMap = orgList.stream().collect(Collectors.toMap(Organization::getWeworkDepartmentId, it -> it));
        ArrayList addOrgList = Lists.newArrayListWithCapacity((int)deptList.size());
        for (WeworkDepartment dept : deptList) {
            Organization parent;
            Long parentId;
            Integer id = dept.getDepartmentId();
            Integer pid = dept.getParentId();
            Organization org = deptOrgMap.get(id);
            if (!this.diffOrg(org, dept, parentId = Long.valueOf((parent = deptOrgMap.get(pid)) != null ? parent.getId() : 0L))) continue;
            addOrgList.add(this.newOrg(bizId, corpId, id, dept.getName(), parentId));
        }
        for (WeworkDepartment dept : deptList) {
            deptOrgMap.remove(dept.getDepartmentId());
        }
        Collection<Organization> delOrgs = deptOrgMap.values();
        if (CollectionUtils.isNotEmpty((Collection)addOrgList)) {
            log.info("add organization list:{}", (Object)addOrgList);
            this.organizationMapper.batchInsert((Collection)addOrgList);
        }
        if (CollectionUtils.isNotEmpty(delOrgs)) {
            Set ids = delOrgs.stream().map(Organization::getId).collect(Collectors.toSet());
            log.info("delete organization ids:{}", ids);
            if (useSuiteToken.booleanValue()) {
                log.info("\u4f7f\u7528\u4e86\u7b2c\u4e09\u65b9\u5e94\u7528access_token\uff0c\u4e0d\u6267\u884c\u5220\u9664\u7ec4\u7ec7\u67b6\u6784\u7684\u64cd\u4f5c\u3002");
            } else {
                this.organizationMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
            }
        }
        ArrayList modOrgList = Lists.newArrayListWithCapacity((int)deptList.size());
        orgList = this.organizationMapper.selectByBizIdAndCorpId(bizId, corpId);
        deptOrgMap = orgList.stream().collect(Collectors.toMap(Organization::getWeworkDepartmentId, it -> it));
        for (WeworkDepartment dept : deptList) {
            Integer id = dept.getDepartmentId();
            Integer pid = dept.getParentId();
            Organization org = deptOrgMap.get(id);
            Organization parent = deptOrgMap.get(pid);
            Long parentId = parent != null ? parent.getId() : 0L;
            if (Objects.equals(parentId, org.getPid())) continue;
            org.setPid(parentId);
            modOrgList.add(org);
        }
        if (CollectionUtils.isNotEmpty((Collection)modOrgList)) {
            log.info("update organization list:{}", (Object)modOrgList);
            this.organizationMapper.batchInsert((Collection)modOrgList);
        }
        this.nodeService.clearCache(bizId);
    }

    private boolean diffOrg(Organization org, WeworkDepartment dept, Long pid) {
        if (org == null) {
            return true;
        }
        if (dept.getName() != null && !Objects.equals(dept.getName(), org.getName())) {
            return true;
        }
        if (!Objects.equals(pid, org.getPid())) {
            log.info("org.pid \u66f4\u65b0, id:{}, pid: {} -> {}", new Object[]{org.getId(), org.getPid(), pid});
            return true;
        }
        return false;
    }

    private Organization newOrg(Long bizId, String corpId, Integer id, String name, Long pid) {
        Organization org = new Organization();
        org.setNum(this.idGen.getNum());
        org.setBizId(bizId);
        org.setCorpId(corpId);
        org.setOrigin(Integer.valueOf(1));
        org.setWeworkDepartmentId(id);
        org.setName(name);
        org.setPid(pid);
        org.setCreateBy(Long.valueOf(-1L));
        org.setCreateTime(new Date());
        org.setUpdateBy(Long.valueOf(-1L));
        org.setUpdateTime(new Date());
        return org;
    }

    private void saveWeworkUser(Long bizId, String corpId, List<UserInfo> list, Map<String, String> openUserIdMap) {
        List existUserIds = this.weworkUserMapper.getWeworkUserIds(corpId);
        if (CollectionUtils.isEmpty(list)) {
            log.warn("\u6ca1\u6709\u62c9\u5230\u6210\u5458\u5217\u8868\uff0ccorpId: {}", (Object)corpId);
            if (CollectionUtils.isNotEmpty((Collection)existUserIds)) {
                log.info("\u6279\u91cf\u53d6\u6d88\u81ea\u5efa\u5e94\u7528\u6388\u6743, corpId={}, userIds={}", (Object)corpId, (Object)existUserIds);
                this.weworkUserMapper.updateAgentDeauth(corpId, (Collection)existUserIds);
            }
            return;
        }
        ArrayList addList = Lists.newArrayList();
        for (UserInfo userInfo : list) {
            WeworkUser record = this.newUser(bizId, corpId, userInfo, openUserIdMap);
            addList.add(record);
            existUserIds.remove(userInfo.getUserId());
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            Lists.partition((List)addList, (int)200).forEach(users -> {
                this.mergeDuplicatedWeworkUsers(corpId, (List<WeworkUser>)users);
                this.weworkUserMapper.batchInsert((Collection)users);
            });
        }
        for (WeworkUser weworkUser : addList) {
            this.updateSysUser(weworkUser);
        }
        if (CollectionUtils.isNotEmpty((Collection)existUserIds)) {
            log.info("\u6279\u91cf\u53d6\u6d88\u81ea\u5efa\u5e94\u7528\u6388\u6743, corpId={}, userIds={}", (Object)corpId, (Object)existUserIds);
            this.weworkUserMapper.updateAgentDeauth(corpId, (Collection)existUserIds);
        }
    }

    private void mergeDuplicatedWeworkUsers(String corpId, List<WeworkUser> addList) {
        if (CollectionUtils.isEmpty(addList)) {
            log.warn("wework user list is empty");
            return;
        }
        int size = addList.size();
        ArrayList weworkUserIds = Lists.newArrayListWithCapacity((int)size);
        ArrayList authUserIds = Lists.newArrayListWithCapacity((int)size);
        for (WeworkUser it2 : addList) {
            weworkUserIds.add(it2.getWeworkUserId());
            authUserIds.add(it2.getAuthUserId());
        }
        log.info("\u68c0\u67e5\u7b2c\u4e09\u65b9\u6388\u6743ID\u548c\u81ea\u5efa\u5e94\u7528\u6388\u6743ID\u662f\u5426\u91cd\u590d\uff0ccorpId={}, weworkUserIds={}, authUserIds={}", new Object[]{corpId, weworkUserIds, authUserIds});
        List agentUsers = this.weworkUserMapper.queryWeworkUserInfoList(corpId, (Collection)weworkUserIds);
        Map<Object, Object> agentUserMap = CollectionUtils.isNotEmpty((Collection)agentUsers) ? agentUsers.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, it -> it)) : Collections.emptyMap();
        List suiteUsers = this.weworkUserMapper.queryWeworkUserInfoListByAuthUserIds(corpId, (Collection)authUserIds);
        Map<Object, Object> suiteUserMap = CollectionUtils.isNotEmpty((Collection)suiteUsers) ? suiteUsers.stream().collect(Collectors.toMap(WeworkUser::getAuthUserId, it -> it)) : Collections.emptyMap();
        ArrayList modAgentUsers = Lists.newArrayListWithCapacity((int)size);
        ArrayList delIds = Lists.newArrayListWithCapacity((int)size);
        for (WeworkUser u : addList) {
            WeworkUser au = (WeworkUser)agentUserMap.get(u.getWeworkUserId());
            WeworkUser su = (WeworkUser)suiteUserMap.get(u.getAuthUserId());
            if (au == null || su == null || Objects.equals(au.getId(), su.getId())) continue;
            log.info("\u53d1\u73b0\u91cd\u590d\u7684\u6210\u5458, agent.id:{}, suite.id:{}, corpId={}, {} -> {}", new Object[]{au.getId(), su.getId(), corpId, u.getWeworkUserId(), u.getAuthUserId()});
            log.info("\u9700\u8981\u5220\u9664 suite id:{}, weworkUserId:{}, authUserId:{}, syncStatus:{}", new Object[]{su.getId(), su.getWeworkUserId(), su.getAuthUserId(), su.getSyncStatus()});
            delIds.add(su.getId());
            au.setIsSuiteAuth(su.getIsSuiteAuth());
            au.setSuiteAuthTime(su.getSuiteAuthTime());
            au.setSuiteDeauthTime(su.getSuiteDeauthTime());
            modAgentUsers.add(au);
        }
        if (CollectionUtils.isNotEmpty((Collection)modAgentUsers)) {
            log.info("\u9700\u8981\u66f4\u65b0agentUser\u7684isSuiteAuth\u72b6\u6001, corpId={}, size={}", (Object)corpId, (Object)modAgentUsers.size());
            this.weworkUserMapper.deleteByIds((Collection)delIds);
            this.weworkUserMapper.batchUpdateSuiteAuth((List)modAgentUsers);
        }
    }

    private void mergeDuplicatedWeworkUser(String corpId, String weworkUserId, String authUserId) {
        log.info("\u68c0\u67e5\u7b2c\u4e09\u65b9\u6388\u6743ID\u548c\u81ea\u5efa\u5e94\u7528\u6388\u6743ID\u662f\u5426\u91cd\u590d\uff0ccorpId={}, weworkUserId={}, authUserId={}", new Object[]{corpId, weworkUserId, authUserId});
        WeworkUser au = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        WeworkUser su = this.weworkUserMapper.getByAuthUserId(corpId, authUserId);
        if (au == null || su == null) {
            log.info("\u672a\u53d1\u73b0\u4f01\u4e1a\u6210\u5458\u552f\u4e00\u952e\u51b2\u7a81\u3002corpId={}, weworkUserId={}, authUserId={}", new Object[]{corpId, weworkUserId, authUserId});
            return;
        }
        if (Objects.equals(au.getId(), su.getId())) {
            log.info("\u672a\u53d1\u73b0\u4f01\u4e1a\u6210\u5458\u552f\u4e00\u952e\u51b2\u7a81\u3002corpId={}, weworkUserId={}, authUserId={}", new Object[]{corpId, weworkUserId, authUserId});
            return;
        }
        log.info("\u53d1\u73b0\u6210\u5458\u552f\u4e00\u952e\u51b2\u7a81, agent.id:{}, suite.id:{}, corpId={}, {} -> {}", new Object[]{au.getId(), su.getId(), corpId, weworkUserId, authUserId});
        log.info("\u9700\u8981\u5220\u9664 id:{}, weworkUserId:{}, authUserId:{}, syncStatus:{}", new Object[]{su.getId(), su.getWeworkUserId(), su.getAuthUserId(), su.getSyncStatus()});
        this.weworkUserMapper.deleteByPrimaryKey((Object)su.getId());
        log.info("\u9700\u8981\u66f4\u65b0agentUser\u7684isSuiteAuth\u72b6\u6001, corpId={}, weworkUserId={}, authUserId={}", new Object[]{corpId, weworkUserId, authUserId});
        au.setIsSuiteAuth(su.getIsSuiteAuth());
        au.setSuiteAuthTime(su.getSuiteAuthTime());
        au.setSuiteDeauthTime(su.getSuiteDeauthTime());
        this.weworkUserMapper.updateByPrimaryKeySelective((Object)au);
    }

    private WeworkUser newUser(Long bizId, String corpId, UserInfo userInfo, Map<String, String> openUserIdMap) {
        log.info("\u6784\u9020\u4f01\u4e1a\u6210\u5458\u4fe1\u606f, bizId={}, corpId={}, userInfo={}, openUserId={}", new Object[]{bizId, corpId, userInfo, openUserIdMap});
        WeworkUser record = new WeworkUser();
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setWeworkUserId(userInfo.getUserId());
        record.setGender(Integer.valueOf(userInfo.getGender()));
        record.setStatus(Integer.valueOf(userInfo.getStatus()));
        String openUserId = openUserIdMap.get(userInfo.getUserId());
        if (openUserId != null) {
            record.setAuthUserId(openUserId);
            record.setOpenUserId(openUserId);
            record.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()));
        } else {
            record.setAuthUserId(userInfo.getUserId());
            record.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.ONLY_CORP.getValue()));
        }
        record.setMainDepartment(userInfo.getMainDepartment());
        record.setName(userInfo.getName());
        record.setAlias(userInfo.getAlias());
        record.setPosition(userInfo.getPosition());
        record.setMobile(userInfo.getMobile() == null ? "" : userInfo.getMobile());
        record.setEmail(userInfo.getEmail());
        record.setAvatar(userInfo.getAvatar());
        record.setThumbAvatar(userInfo.getThumbAvatar());
        record.setTelephone(userInfo.getTelephone());
        record.setAddress(userInfo.getAddress());
        record.setQrCode(userInfo.getQrCode());
        record.setVcode(this.getVCode(userInfo.getQrCode()));
        record.setExternalPosition(userInfo.getExternalPosition());
        String exAttr = null;
        if (userInfo.getExtattr() != null) {
            exAttr = JacksonUtil.obj2Str((Object)userInfo.getExtattr().getAttrs());
        }
        record.setExtAttr(exAttr);
        String externalProfile = null;
        if (userInfo.getExternalProfile() != null) {
            externalProfile = JacksonUtil.obj2Str((Object)userInfo.getExternalProfile());
        }
        record.setExternalProfile(externalProfile);
        record.setNum(this.idGen.getNum());
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setIsDeleted(Integer.valueOf(0));
        return record;
    }

    private void saveDepartmentUser(Long bizId, String corpId, List<UserInfo> list) {
        Collection<Object> remainList;
        ArrayList addList = Lists.newArrayList();
        String format = "%s##%d";
        List existsList = this.weworkDepartmentUserMapper.selectByCorpId(corpId);
        Map<Object, Object> existsMap = CollectionUtils.isNotEmpty((Collection)existsList) ? existsList.stream().collect(Collectors.toMap(it -> {
            String weworkUserId = it.getWeworkUserId();
            Integer deptId = it.getDepartmentId();
            return String.format(format, weworkUserId, deptId);
        }, it -> it)) : new HashMap();
        for (UserInfo userInfo : list) {
            String weworkUserId = userInfo.getUserId();
            List departmentIds = userInfo.getDepartment();
            List isLeaders = userInfo.getIsLeaderInDept();
            List orders = userInfo.getOrder();
            for (int i = 0; i < departmentIds.size(); ++i) {
                Integer deptId = (Integer)departmentIds.get(i);
                Integer order = (Integer)orders.get(i);
                Integer isLeader = (Integer)isLeaders.get(i);
                String key = String.format(format, weworkUserId, deptId);
                WeworkDepartmentUser exist = (WeworkDepartmentUser)existsMap.remove(key);
                if (!this.diffDeptUser(exist, order, isLeader)) continue;
                WeworkDepartmentUser record = this.newDeptUser(bizId, corpId, weworkUserId, deptId, order, isLeader);
                addList.add(record);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            log.info("save dept user list, size:{}", (Object)addList.size());
            Lists.partition((List)addList, (int)200).forEach(it -> this.weworkDepartmentUserMapper.batchInsert((Collection)it));
        }
        if (!CollectionUtils.isEmpty(remainList = existsMap.values())) {
            Set delIds = remainList.stream().map(WeworkDepartmentUser::getId).collect(Collectors.toSet());
            log.info("delete dept user list, ids:{}", delIds);
            this.weworkDepartmentUserMapper.delDepartmentUser(delIds);
        }
    }

    private void saveDepartmentUser(Long bizId, String corpId, UserInfo userInfo) {
        String weworkUserId = userInfo.getUserId();
        List departmentIds = userInfo.getDepartment();
        List isLeaders = userInfo.getIsLeaderInDept();
        List orders = userInfo.getOrder();
        Date now = new Date();
        ArrayList insertList = Lists.newArrayList();
        List exists = this.weworkDepartmentUserMapper.selectExistDepartmentUser(corpId, weworkUserId);
        if (CollectionUtils.isEmpty((Collection)departmentIds)) {
            log.info("department is empty, corpId:{}, userId:{}", (Object)corpId, (Object)weworkUserId);
            if (CollectionUtils.isNotEmpty((Collection)exists)) {
                List ids = exists.stream().map(WeworkDepartmentUser::getId).collect(Collectors.toList());
                this.weworkDepartmentUserMapper.delDepartmentUser(ids);
                log.info("delete wework_department_user, ids:{}", ids);
            }
            return;
        }
        Map<Object, Object> existMap = CollectionUtils.isNotEmpty((Collection)exists) ? exists.stream().collect(Collectors.toMap(WeworkDepartmentUser::getDepartmentId, it -> it)) : Maps.newHashMap();
        for (int i = 0; i < departmentIds.size(); ++i) {
            Integer departmentId = (Integer)departmentIds.get(i);
            Integer isLeader = (Integer)isLeaders.get(i);
            Integer order = (Integer)orders.get(i);
            WeworkDepartmentUser record = (WeworkDepartmentUser)existMap.remove(departmentId);
            if (record == null) {
                record = new WeworkDepartmentUser();
                record.setBizId(bizId);
                record.setCorpId(corpId);
                record.setWeworkUserId(weworkUserId);
                record.setDepartmentId(departmentId);
                record.setCreateTime(now);
            }
            record.setIsLeaderInDept(isLeader);
            record.setOrder(order);
            record.setUpdateTime(now);
            record.setIsDeleted(Integer.valueOf(0));
            insertList.add(record);
        }
        this.weworkDepartmentUserMapper.batchInsert((Collection)insertList);
        if (!existMap.isEmpty()) {
            List ids = existMap.values().stream().map(WeworkDepartmentUser::getId).collect(Collectors.toList());
            this.weworkDepartmentUserMapper.delDepartmentUser(ids);
        }
    }

    private boolean diffDeptUser(WeworkDepartmentUser exist, Integer order, Integer isLeader) {
        if (exist == null) {
            return true;
        }
        if (isLeader != null && !Objects.equals(isLeader, exist.getIsLeaderInDept())) {
            return true;
        }
        return order != null && !Objects.equals(order, exist.getOrder());
    }

    private WeworkDepartmentUser newDeptUser(Long bizId, String corpId, String weworkUserId, Integer deptId, Integer order, Integer isLeader) {
        WeworkDepartmentUser record = new WeworkDepartmentUser();
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setWeworkUserId(weworkUserId);
        record.setDepartmentId(deptId);
        record.setIsLeaderInDept(isLeader);
        record.setOrder(order);
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setIsDeleted(Integer.valueOf(0));
        return record;
    }

    private void addFakeRootDept(List<Department> list, String corpId) {
        log.info("try add fake root, corpId={}, list={}", (Object)corpId, list);
        boolean hasRoot = false;
        for (Department dept : list) {
            if (dept.getId() != 1) continue;
            hasRoot = true;
            break;
        }
        if (hasRoot) {
            log.info("found root department, no need to add fake one.");
            return;
        }
        log.warn("root department not found, corpId:{}, deptList:{}", (Object)corpId, list);
        WeworkCorp corp = this.weworkCorpMapper.getByCorpId(corpId);
        if (corp == null) {
            log.warn("corp not found, corpId:{}", (Object)corpId);
            return;
        }
        String name = corp.getCorpFullName() == null ? corp.getCorpName() : corp.getCorpFullName();
        Department root = new Department();
        root.setId(Integer.valueOf(1));
        root.setParentId(Integer.valueOf(0));
        root.setName(name);
        root.setOrder(Integer.valueOf(100000000));
        for (Department dept : list) {
            if (dept.getId() == 1 || dept.getParentId() != 0) continue;
            dept.setParentId(Integer.valueOf(1));
        }
        list.add(0, root);
    }

    private void addFakeUserDept(UserInfo u) {
        if (u.getMainDepartment() == null || u.getMainDepartment() == 0) {
            log.info("user main department is empty, userId:{}", (Object)u.getUserId());
            u.setMainDepartment(Integer.valueOf(1));
        }
        if (CollectionUtils.isEmpty((Collection)u.getDepartment())) {
            log.info("user department list is empty, userId:{}", (Object)u.getUserId());
            u.setDepartment(Collections.singletonList(1));
            u.setOrder(Collections.singletonList(0));
            u.setIsLeaderInDept(Collections.singletonList(0));
        }
    }

    private void fixNodeIds(String corpId, String weworkUserId) {
        List diffNodeIds = this.userMapper.diffNodeIds(corpId, weworkUserId);
        if (CollectionUtils.isEmpty((Collection)diffNodeIds)) {
            return;
        }
        log.info("\u53d1\u73b0\u4e0b\u5217\u6210\u5458\u7684\u7ec4\u7ec7\u67b6\u6784\u53d1\u751f\u53d8\u66f4\uff0c\u9700\u8981\u66f4\u65b0:{}", (Object)diffNodeIds);
        ArrayList list = Lists.newArrayList();
        for (UserDiffNodeDto dto : diffNodeIds) {
            User record = new User();
            record.setId(dto.getId());
            record.setNodeId(dto.getNewNodeId());
            list.add(record);
        }
        int ret = this.userMapper.updateNodeIds((List)list);
        if (ret > 0) {
            log.info("\u5df2\u4fee\u590d\u4e0a\u8ff0\u7528\u6237\u7684nodeId");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUserId(String corpId, String weworkUserId, String newUserId, Long timestamp) {
        log.info("update weworkUserId, corpId:{}, old:{}, new:{}", new Object[]{corpId, weworkUserId, newUserId});
        WeworkUser existUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        if (existUser == null) {
            log.info("wework user not found, corpId:{}, weworkUserId:{}", (Object)corpId, (Object)weworkUserId);
            return;
        }
        int ret = this.weworkUserMapper.updateWeworkUserId(corpId, weworkUserId, newUserId);
        if (ret > 0) {
            log.info("update wework_user.wework_user_id, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{corpId, weworkUserId, newUserId});
        }
        if ((ret = this.weworkDepartmentUserMapper.updateWeworkUserId(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update wework_department_user.wework_user_id, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
        if ((ret = this.weworkContactRelationMapper.updateWeworkUserId(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update wework_contact_relation.wework_user_id, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
        if ((ret = this.weworkContactTagMapper.updateWeworkUserId(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update wework_contact_tag.wework_user_id, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
        if ((ret = this.weworkContactMobileMapper.updateWeworkUserId(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update wework_contact_mobile.wework_user_id, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
        if ((ret = this.weworkChatRoomMapper.updateOwner(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update wework_chat_room.owner, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
        if ((ret = this.weworkChatRoomRelationMapper.updateMemberId(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update wework_chat_room_relation.member_id, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
        if ((ret = this.weworkChatRoomRelationMapper.updateInvitor(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update wework_chat_room_relation.invitor, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
        if ((ret = this.weworkGroupMsgResultMapper.updateWeworkUserId(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update wework_group_msg_result.wework_user_id, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
        if ((ret = this.weworkGroupMsgTaskMapper.updateWeworkUserId(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update wework_group_msg_task.wework_user_id, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
        if ((ret = this.weworkConversationMapper.updateWeworkUserId(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update wework_conversation.wework_user_id, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
        if ((ret = this.userMapper.updateWeworkUserId(corpId, weworkUserId, newUserId)) > 0) {
            log.info("update user.wework_user_id, modified:{}, corpId:{}, weworkUserId:{}, newUserId:{}", new Object[]{ret, corpId, weworkUserId, newUserId});
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public WeworkUser subscribe(Long bizId, String corpId, String weworkUserId, String accessToken) {
        UserInfo userInfo;
        try {
            userInfo = this.userApi.get(accessToken, weworkUserId);
            log.info("fetch user info:{}", (Object)userInfo);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, weworkUserId:{}", new Object[]{e.getMessage(), corpId, weworkUserId});
            throw e;
        }
        catch (Exception e) {
            log.error("fetch user info failed, corpId:{}, weworkUserId:{}", new Object[]{corpId, weworkUserId, e});
            throw e;
        }
        this.addFakeUserDept(userInfo);
        Map<String, String> openUserIdMap = this.fetchOpenUserIds(corpId, Collections.singletonList(weworkUserId));
        String openUserId = openUserIdMap.get(weworkUserId);
        if (openUserId != null) {
            this.mergeDuplicatedWeworkUser(corpId, weworkUserId, openUserId);
        }
        WeworkUser weworkUser = this.newUser(bizId, corpId, userInfo, openUserIdMap);
        this.weworkUserMapper.batchInsert(Collections.singletonList(weworkUser));
        this.saveDepartmentUser(bizId, corpId, userInfo);
        return weworkUser;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUser(String corpId, String weworkUserId, Long timestamp) {
        UserInfo userInfo;
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.info("bizId is null, corpId: {}", (Object)corpId);
            return;
        }
        BusinessCustomer biz = this.businessCustomerMapper.getByCorpId(corpId);
        if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
            log.warn("biz corpId is not synchronized, skip this step. bizId={}, corpId={}", (Object)bizId, (Object)corpId);
            return;
        }
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            return;
        }
        try {
            userInfo = this.userApi.get(accessToken, weworkUserId);
            log.info("fetch user info:{}", (Object)userInfo);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, weworkUserId:{}", new Object[]{e.getMessage(), corpId, weworkUserId});
            throw e;
        }
        catch (Exception e) {
            log.error("fetch user info failed, corpId:{}, weworkUserId:{}", new Object[]{corpId, weworkUserId, e});
            throw e;
        }
        this.addFakeUserDept(userInfo);
        Map<String, String> openUserIdMap = this.fetchOpenUserIds(corpId, Collections.singletonList(weworkUserId));
        String openUserId = openUserIdMap.get(weworkUserId);
        if (openUserId != null) {
            this.mergeDuplicatedWeworkUser(corpId, weworkUserId, openUserId);
        }
        WeworkUser weworkUser = this.newUser(bizId, corpId, userInfo, openUserIdMap);
        this.weworkUserMapper.batchInsert(Collections.singletonList(weworkUser));
        this.updateSysUser(weworkUser);
        this.saveDepartmentUser(bizId, corpId, userInfo);
        this.fixNodeIds(corpId, weworkUserId);
    }

    private void updateSysUser(WeworkUser weworkUser) {
        String corpId = weworkUser.getCorpId();
        String weworkUserId = weworkUser.getWeworkUserId();
        String authUserId = weworkUser.getAuthUserId();
        try {
            boolean isUpdateUser = false;
            User existUser = this.userMapper.selectUserByWeworkUserIdAndCorpId(weworkUserId, corpId);
            User authUser = this.userMapper.selectUserByWeworkUserIdAndCorpId(authUserId, corpId);
            if (authUser != null) {
                if (existUser == null) {
                    log.info("\u91cd\u65b0\u914d\u7f6e\u7ba1\u7406\u5458\u7684wework_user_id, corpId:{}, weworkUserId:{}, openUserId:{}", new Object[]{corpId, weworkUserId, authUserId});
                    authUser.setWeworkUserId(weworkUser.getWeworkUserId());
                    authUser.setIdentifier(weworkUser.getWeworkUserId());
                    authUser.setAvatar(weworkUser.getAvatar());
                    authUser.setName(weworkUser.getName());
                    authUser.setMobile(weworkUser.getMobile());
                    authUser.setIsDeleted(Integer.valueOf(0));
                    authUser.setUpdateTime(new Date());
                    this.userMapper.updateByPrimaryKeySelective((Object)authUser);
                    return;
                }
                if (!Objects.equals(existUser.getId(), authUser.getId())) {
                    log.info("\u5220\u9664\u91cd\u590d\u7684\u7ba1\u7406\u5458\u8d26\u53f7\uff0ccorpId:{}, userId:{}", (Object)corpId, (Object)authUser.getId());
                    this.userMapper.deleteByPrimaryKey((Object)authUser.getId());
                }
            }
            if (existUser != null) {
                if (StringUtils.isBlank((CharSequence)existUser.getName()) || !existUser.getName().equals(weworkUser.getName())) {
                    existUser.setName(weworkUser.getName());
                    isUpdateUser = true;
                }
                if (StringUtils.isBlank((CharSequence)existUser.getMobile()) || !existUser.getMobile().equals(weworkUser.getMobile())) {
                    existUser.setMobile(weworkUser.getMobile());
                    isUpdateUser = true;
                }
                if (StringUtils.isBlank((CharSequence)existUser.getAvatar()) || !existUser.getAvatar().equals(weworkUser.getAvatar())) {
                    existUser.setAvatar(weworkUser.getAvatar());
                    isUpdateUser = true;
                }
                if (isUpdateUser) {
                    this.userMapper.updateByPrimaryKey((Object)existUser);
                }
            }
        }
        catch (Exception e) {
            log.error("update sys user error: ", (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteUser(String corpId, String weworkUserId, Long timestamp) {
        List<String> weworkUserIds = Collections.singletonList(weworkUserId);
        log.info("\u53d6\u6d88\u7b2c\u4e09\u65b9\u5e94\u7528\u6388\u6743\uff0ccorpId={}, weworkUserId={}", (Object)corpId, (Object)weworkUserId);
        this.weworkUserMapper.updateSuiteDeauth(corpId, weworkUserIds);
        this.deleteUser(corpId, weworkUserIds, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSuiteUser(String authCorpId, String authUserId, Long timestamp) {
        Long bizId = authCorpId.startsWith("wp") ? this.businessCustomerMapper.getExistIdByAuthCorpId(authCorpId) : this.businessCustomerMapper.getExistBizId(authCorpId);
        if (bizId == null) {
            log.warn("\u5546\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664. authCorpId:{}", (Object)authCorpId);
            return;
        }
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
            log.warn("biz corpId is not synchronized, skip this step. bizId={}, authCorpId={}", (Object)bizId, (Object)authCorpId);
            return;
        }
        String corpId = biz.getCorpId();
        WeworkUser weworkUser = authCorpId.startsWith("wp") ? this.weworkUserMapper.getByAuthUserId(corpId, authUserId) : this.weworkUserMapper.queryWeworkUserInfo(corpId, authUserId);
        if (weworkUser == null) {
            log.info("wework_user not found, authCorpId:{}, authUserId:{}", (Object)authCorpId, (Object)authUserId);
            return;
        }
        List<String> weworkUserIds = Collections.singletonList(weworkUser.getWeworkUserId());
        log.info("\u53d6\u6d88\u7b2c\u4e09\u65b9\u5e94\u7528\u6388\u6743\uff0ccorpId={}, weworkUserId={}", (Object)corpId, (Object)weworkUser.getWeworkUserId());
        this.weworkUserMapper.updateSuiteDeauth(corpId, weworkUserIds);
        this.deleteUser(corpId, weworkUserIds, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createParty(String corpId, Integer id, String name, Integer parentId, Integer order, Long timestamp) {
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.info("bizId is null, corpId: {}", (Object)corpId);
            return;
        }
        WeworkDepartment record = new WeworkDepartment();
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setDepartmentId(id);
        record.setName(name);
        record.setParentId(parentId);
        record.setOrder(order);
        record.setNum(this.idGen.getNum());
        record.setCreateTime(new Date());
        record.setCreateBy(Long.valueOf(-1L));
        record.setUpdateTime(new Date());
        record.setUpdateBy(Long.valueOf(-1L));
        record.setIsDeleted(Integer.valueOf(0));
        this.weworkDepartmentMapper.batchInsert(Collections.singletonList(record));
        this.saveOrganization(bizId, corpId, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncSuiteParty(String authCorpId, Long timestamp) {
        Long bizId = this.businessCustomerMapper.getIdByAuthCorpId(authCorpId);
        if (bizId == null) {
            log.info("bizId is null, authCorpId: {}", (Object)authCorpId);
            return;
        }
        BusinessCustomer biz = this.businessCustomerMapper.getByAuthCorpId(authCorpId);
        if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
            log.warn("biz corpId is not synchronized, skip this step. bizId={}, authCorpId={}", (Object)bizId, (Object)authCorpId);
            return;
        }
        String corpId = biz.getCorpId();
        log.info("get department list, corpId:{}", (Object)corpId);
        String accessToken = this.suiteTokenService.getSuiteAccessToken(corpId);
        try {
            List fetchDeptList = this.departmentApi.list(accessToken, null);
            log.info("Fetch department list:{}", (Object)fetchDeptList);
            this.saveWeworkDepartment(bizId, corpId, fetchDeptList, true);
            this.saveOrganization(bizId, corpId, true);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", (Object)e.getMessage(), (Object)corpId);
            throw e;
        }
        catch (Exception e) {
            log.error("Fetch department list failed.", (Throwable)e);
            throw e;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateParty(String corpId, Integer id, String name, Integer parentId, Long timestamp) {
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.info("bizId is null, corpId: {}", (Object)corpId);
            return;
        }
        WeworkDepartment exist = this.weworkDepartmentMapper.getDepartment(corpId, id);
        if (!this.diffDept(exist, name, parentId)) {
            log.info("department not change, corpId:{}, id:{}", (Object)corpId, (Object)id);
            return;
        }
        if (exist == null && parentId == null) {
            log.warn("\u90e8\u95e8\u4e0d\u5b58\u5728");
            return;
        }
        WeworkDepartment record = new WeworkDepartment();
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setDepartmentId(id);
        if (name != null) {
            record.setName(name);
        }
        if (parentId != null) {
            record.setParentId(parentId);
        }
        record.setNum(this.idGen.getNum());
        record.setCreateTime(new Date());
        record.setCreateBy(Long.valueOf(-1L));
        record.setUpdateTime(new Date());
        record.setUpdateBy(Long.valueOf(-1L));
        record.setIsDeleted(Integer.valueOf(0));
        this.weworkDepartmentMapper.batchInsert(Collections.singletonList(record));
        this.saveOrganization(bizId, corpId, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteParty(String corpId, Integer id, Long timestamp) {
        log.info("delete party, corpId:{}, deptId:{}, timestamp:{}", new Object[]{corpId, id, timestamp});
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.info("bizId is null, corpId: {}", (Object)corpId);
            return;
        }
        List<Integer> deptIds = Collections.singletonList(id);
        int ret = this.weworkDepartmentMapper.delDepartmentList(corpId, deptIds);
        if (ret > 0) {
            log.info("\u5220\u9664\u90e8\u95e8, modified:{}", (Object)ret);
        }
        if ((ret = this.weworkDepartmentUserMapper.delDepartmentUserByDept(corpId, deptIds)) > 0) {
            log.info("\u5220\u9664\u90e8\u95e8\u6210\u5458\u5173\u7cfb, modified:{}", (Object)ret);
        }
        if ((ret = this.organizationMapper.logicDeleteByDeptIds(corpId, deptIds)) > 0) {
            this.nodeService.clearCache(bizId);
            log.info("\u5220\u9664\u7ec4\u7ec7\u67b6\u6784, modified:{}", (Object)ret);
        }
    }

    private boolean diffDept(WeworkDepartment exist, String name, Integer parentId) {
        if (exist == null) {
            return true;
        }
        if (name != null && !Objects.equals(name, exist.getName())) {
            log.info("diff name, old:{}, new:{}", (Object)exist.getName(), (Object)name);
            return true;
        }
        if (parentId != null && !Objects.equals(parentId, exist.getParentId())) {
            log.info("diff parentId, old:{}, new:{}", (Object)exist.getParentId(), (Object)parentId);
            return true;
        }
        return false;
    }

    private String getVCode(String qrCode) {
        if (StringUtils.isBlank((CharSequence)qrCode)) {
            return null;
        }
        Matcher matcher = VCODE_REGEX.matcher(qrCode);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

